﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The radiology value.
    /// </summary>
    public class RadiologyValue
    {
        /// <summary>
        /// Gets or sets the radiology value id.
        /// </summary>
        [Key, Identity]
        public int RadiologyValueId { get; set; }

        /// <summary>Gets or sets the radiology id.</summary>
        public int RadiologyId { get; set; }

        /// <summary>Gets or sets the order code.</summary>
        public string OrderCode { get; set; }

        /// <summary>Gets or sets the code.</summary>
#pragma warning disable CS8632 // The annotation for nullable reference types should only be used in code within a '#nullable' annotations context.
        public string? Code { get; set; }
#pragma warning restore CS8632 // The annotation for nullable reference types should only be used in code within a '#nullable' annotations context.

        /// <summary>Gets or sets the name.</summary>
        public string Name { get; set; }

        /// <summary>Gets or sets the type.</summary>
#pragma warning disable CS8632 // The annotation for nullable reference types should only be used in code within a '#nullable' annotations context.
        public string? Test { get; set; }
#pragma warning restore CS8632 // The annotation for nullable reference types should only be used in code within a '#nullable' annotations context.

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>Gets or sets the modified by.</summary>
        public int? ModifiedBy { get; set; }

        /// <summary>Gets or sets the modified date.</summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
