﻿
namespace Hims.Domain.Services
{
    using Hims.Domain.Entities;
    using Hims.Shared.EntityModels;
    using Hims.Shared.Library;
    using Hims.Shared.Library.Enums;
    using Hims.Shared.Library.Helpers;
    using Hims.Shared.UserModels;
    using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

    /// <summary>
    /// The iivf encounter services
    /// </summary>

    public interface IIvfEncounterServices
    {

        /// <summary>
        /// The add ivf encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> AddAsync(IvfEncounterModifyModel model);

        /// <summary>
        /// The add ivf encounter async.
        /// </summary>
        /// <param name="model">
        /// The model.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<CommonResponse> UpdateAsync(IvfEncounterModifyModel model);
        /// <summary>
        /// Finds the asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<IvfEncounter> FindAsync(int appointmentId, bool isAdmission);
        /// <summary>
        /// Finds the dashboard asynchronous.
        /// </summary>
        /// <param name="appointmentId">The appointment identifier.</param>
        /// <param name="type">The type.</param>
        /// <param name="isAdmission">if set to <c>true</c> [is admission].</param>
        /// <returns></returns>
        Task<IvfEncounterResource> FindDashboardAsync(int appointmentId, IvfEncounterType type, bool isAdmission);
        /// <summary>
        /// The find full transcript async.
        /// </summary>
        /// <param name="appointmentId">
        /// The appointment id.
        /// </param>
        Task<IvfEncounterFullTranscriptModel> FindFullTranscriptAsync(int appointmentId);




    }
}
