﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.PatientMedication;
    using Shared.UserModels.Laboratory;
    using Shared.UserModels.Labs;

    /// <summary>
    /// The patient medication service interface.
    /// </summary>
    public interface IPatientEncounterService
    {
        /// <summary>
        /// Adds the patient medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddPatientMedicationAsync(PatientMedicationHeaderModel model);

        /// <summary>
        /// Fetches the patient medication.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PatientMedicationHeaderModel>> FetchPatientMedication(PatientMedicationHeaderModel model);

        /// <summary>
        /// Deletes the single medication asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteSingleMedicationAsync(PatientMedicationDetailModel model);

        /// <summary>
        /// Adds the patient lab asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> AddPatientLabAsync(AddBooking model);

        /// <summary>
        /// Fetches the patient labs asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PatientMedicationHeaderModel>> FetchPatientLabsAsync(PatientMedicationHeaderModel model);

        /// <summary>
        /// Deletes the single lab asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteSingleLabAsync(PatientMedicationDetailModel model);

        /// <summary>
        /// Verifies the lab report without package asynchronous.
        /// </summary>
        /// <param name="labBookingDetailId">The lab booking detail identifier.</param>
        /// <param name="verifiedBy">The verified by.</param>
        /// <returns></returns>
        Task<int> VerifyLabReportWithoutPackageAsync(int labBookingDetailId, int verifiedBy);

        /// <summary>
        /// Verifies the lab booking package asynchronous.
        /// </summary>
        /// <param name="verifiedBy">The verified by.</param>
        /// <param name="labBookingDetailId">The lab booking detail identifier.</param>
        /// <param name="labBookingPackageDetailId">The lab booking package detail identifier.</param>
        /// <returns></returns>
        Task<int> VerifyLabBookingPackageAsync(int verifiedBy, int? labBookingDetailId, int? labBookingPackageDetailId);

        /// <summary>
        /// Fetches the frequently used labs asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<LabMainDetailModel>> FetchFrequentlyUsedLabsAsync(LabMainDetailModel model);

        /// <summary>
        /// Fetches the frequently used medications.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<PatientMedicationDetailModel>> FetchFrequentlyUsedMedications(PatientMedicationDetailModel model);
    }
}
