﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The dental full transcript model.
    /// </summary>
    public class DentalFullTranscriptModel
    {
        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string? PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public char? PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string? PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public short? PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient date of birth.
        /// </summary>
        public DateTime? PatientDateOfBirth { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string? PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTimeString
        /// </summary>
        public string? AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the dental encounter id.
        /// </summary>
        public int DentalEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the medical history.
        /// </summary>
        public string? MedicalHistory { get; set; }

        /// <summary>
        /// Gets or sets the dental history.
        /// </summary>
        public string? DentalHistory { get; set; }

        /// <summary>
        /// Gets or sets the family history.
        /// </summary>
        public string? FamilyHistory { get; set; }

        /// <summary>
        /// Gets or sets the oral hygiene.
        /// </summary>
        public string? OralHygiene { get; set; }

        /// <summary>
        /// Gets or sets the clinical findings.
        /// </summary>
        public string? ClinicalFindings { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        public string? Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string? Medications { get; set; }

        /// <summary>
        /// Gets or sets the personal habits.
        /// </summary>
        public string? PersonalHabits { get; set; }

        /// <summary>
        /// Gets or sets the chief complaints.
        /// </summary>
        public string? ChiefComplaints { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string? ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string? MedicationComment { get; set; }
    }
}
