﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.EntityModels
{

    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;
    using Shared.Library.Enums;

    /// <summary>
    /// The encounter.
    /// </summary>
    public class GeneticSpecialityEncounterModel
    {

        ///<summary>
        /// Gets or sets the genetic specialty encounterId
        ///</summary>
        
        public int? GeneticSpecialityEncounterId { get; set; }
        ///<summary>
        ///Gets or sets the appointmentId
        ///</summary>
        public int? AppointmentId { get; set; }
        ///<summary>
        ///Gets or sets the active
        ///</summary>
        public Boolean? Active { get; set; }
        ///<summary>
        ///Gets or sets the created by
        ///</summary>
        public int CreatedBy { get; set; }
        ///<summary>
        ///Gets or sets the created date
        ///</summary>
        public DateTime? CreatedDate { get; set; }
        ///<summary>
        ///Gets or sets the modified by
        ///</summary>
        public int? ModifiedBy { get; set; }
        ///<summary>
        ///Gets or sets the modified date
        ///</summary>
        public DateTime? ModifiedDate { get; set; }
        ///<summary>
        ///Gets or sets the genetic special encounter type
        ///</summary>
        public GeneticSpecialEncounterType Type { get; set; }
        ///<summary>
        ///Gets or sets the json string
        ///</summary>
        public string JsonString { get; set; }
        ///<summary>
        ///Gets or sets the encrypted appointmentId
        ///</summary>
        public string EncryptedAppointmentId { get; set; }
        ///<summary>
        ///Gets or sets the special features page
        ///</summary>
        public string? SpecialFeaturesPage { get; set; }
        ///<summary>
        ///Gets or sets the genetic isit
        ///</summary>
        public string? GeneticVisit { get; set; }
        ///<summary>
        ///Gets or sets outsideTest
        ///</summary>
        public string? OutsideTest { get; set; }
    }
}

 