﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The patient insurance.
    /// </summary>
    public class PatientInsuranceModels 
    {
        /// <summary>
        /// Gets or sets the patient insurance id.
        /// </summary>
        public List<PatientInsuranceModel> Insurances { get; set; }
    }

    /// <summary>
    /// The patient insurance.
    /// </summary>
    public class PatientInsuranceModel
    {
        /// <summary>
        /// Gets or sets the patient insurance id.
        /// </summary>
        public int? PatientInsuranceId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
       // public int InsuranceTypeId { get; set; }
        public int? InsuranceTypeId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company id.
        /// </summary>
       // public int InsuranceCompanyId { get; set; }
        public int? InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company name.
        /// </summary>
        public string? InsuranceCompanyName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the validity.
        /// </summary>
        //public DateTime Validity { get; set; }
        public DateTime? Validity { get; set; }

        /// <summary>
        /// Gets or sets the card no.
        /// </summary>
        public string CardNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
