﻿using Hims.Shared.Library.Enums;
using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.DietEncounter
{
    public class DietEncounterFiltersModel
    {

        /// <summary>
        /// Gets or sets the id.
        /// </summary>
        public int? DietEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted encounter id.
        /// </summary>
        public string? EncryptedEncounterId { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public DietEncounterType Type { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the page index.
        /// </summary>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the page size.
        /// </summary>
        public int? PageSize { get; set; }


    }
}
