﻿namespace Hims.Shared.UserModels
{
    using System;

    /// <summary>
    /// The issue approve model.
    /// </summary>
    public class IssueApproveModel
    {
        /// <summary>
        /// Gets or sets the indent header id.
        /// </summary>
        public int IndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the stock id.
        /// </summary>
        public int StockId { get; set; }

        /// <summary>
        ///  Gets or sets the product id.
        /// </summary>
        public int ProductId { get; set; }

        /// <summary>
        /// Gets or sets the issue date.
        /// </summary>
        public DateTime IssueDate { get; set; }

        /// <summary>
        /// Gets or sets the approved date.
        /// </summary>
        public DateTime ApprovedDate { get; set; }

        /// <summary>
        /// Gets or sets the issue quantity.
        /// </summary>
        public int IssueQuantity { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the indent to.
        /// </summary>
        public string IndentTo { get; set; }

        /// <summary>
        /// Gets or sets the role id .
        /// </summary>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the request indent status id .
        /// </summary>
        public int RequestIndentStatusId { get; set; }

    }
}
