﻿namespace Hims.Shared.UserModels.PharmacyRequest
{
    using System;
    using System.Collections.Generic;
    using System.Text;

    /// <summary>
    /// The indent request model.
    /// </summary>
    public class IndentRequestModel
    {
        /// <summary>
        /// Gets or sets the indent date.
        /// </summary>
        public DateTime IndentDate { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int? DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the required date.
        /// </summary>
        public DateTime RequiredDate { get; set; }

        /// <summary>
        /// Gets or sets the reason.
        /// </summary>
        public string Reason { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int? PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }


        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }


        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? ProductName { get; set; }


        /// <summary>
        /// Gets or sets the  comments.
        /// </summary>
        public int? RoleId { get; set; }


        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the  pharmacy Indent header id.
        /// </summary>
        public int PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the  pharmacy Indent header id.
        /// </summary>
        public int PharmacyIndentDetailId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }
    }
}
