﻿using System.Collections.Generic;

namespace Hims.Shared.UserModels.ServiceOrder
{
    /// <summary>
    /// The receipt model
    /// </summary>
    public class FilterModel
    {
        /// <summary>
        /// Gets or sets the admission identifier.
        /// </summary>
        /// <value>
        /// The admission identifier.
        /// </value>
        public int AdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the identifier.
        /// </summary>
        /// <value>
        /// The identifier.
        /// </value>
        public string Id { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="FilterModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool ActiveOnly { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is admission.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is admission; otherwise, <c>false</c>.
        /// </value>
        public bool IsAdmission { get; set; }

        /// <summary>
        /// Gets or sets the encrypted provider id.
        /// </summary>
        public string? EncryptedProviderId { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int? ProviderId { get; set; }
        /// <summary>
        /// Gets or sets the admission ids.
        /// </summary>
        /// <value>
        /// The admission ids.
        /// </value>
        public List<int> AdmissionIds { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="FilterModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is discharged.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is discharged; otherwise, <c>false</c>.
        /// </value>
        public bool IsDischarged { get; set; }
    }
}
