﻿using System;

namespace Hims.Shared.UserModels.ServiceOrder.Package
{
    /// <summary>
    ///   <br />
    /// </summary>
    public class ViewModel
    {
        /// <summary>
        /// Gets or sets the charge identifier.
        /// </summary>
        /// <value>
        /// The charge identifier.
        /// </value>
        public int PackageId { get; set; }


        /// <summary>
        /// Gets or sets the admission package identifier.
        /// </summary>
        /// <value>
        /// The admission package identifier.
        /// </value>
        public int AdmissionPackageId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge.
        /// </summary>
        /// <value>
        /// The name of the charge.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the total general.
        /// </summary>
        /// <value>
        /// The total general.
        /// </value>
        public int TotalGeneral { get; set; }

        /// <summary>
        /// Gets or sets the total medicines.
        /// </summary>
        /// <value>
        /// The total medicines.
        /// </value>
        public int TotalMedicines { get; set; }

        /// <summary>
        /// Gets or sets the total labs.
        /// </summary>
        /// <value>
        /// The total labs.
        /// </value>
        public int TotalLabs { get; set; }

        /// <summary>
        /// Gets or sets the total kits.
        /// </summary>
        /// <value>
        /// The total kits.
        /// </value>
        public int TotalKits { get; set; }

        /// <summary>
        /// Gets or sets the cost.
        /// </summary>
        /// <value>
        /// The cost.
        /// </value>
        public decimal Cost { get; set; }

        /// <summary>
        /// Gets or sets the unit.
        /// </summary>
        /// <value>
        /// The unit.
        /// </value>
        public int Unit { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="ViewModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        public int PackageModuleId { get; set; }
        public string PackageName { get; set; }
        public int ExpiresIn { get; set; }
        public string ModuleTypeName { get; set; }
        public int Quantity { get; set; }
        public decimal Total { get; set; }
        public int FreeQuantity { get; set; }
        public int LocationId { get; set; }
        public int ChargeModuleTemplateId { get; set; }
        public string ModulesMasterIds { get; set; }
    }
}
