﻿namespace Hims.Domain.Entities.Enums
{
    /// <summary>
    /// The receipt type enum
    /// </summary>
    public enum ReceiptType
    {
        /// <summary>
        /// The cash
        /// </summary>
        Cash = 1,

        /// <summary>
        /// The refund
        /// </summary>
        Refund = 2
    }

    /// <summary>
    /// The receipt area type enum
    /// </summary>
    public enum ReceiptAreaType
    {
        /// <summary>
        /// The pharmacy
        /// </summary>
        Pharmacy = 1,

        /// <summary>
        /// The general
        /// </summary>
        General,

        /// <summary>
        /// The PatientRegistration
        /// </summary>
        PatientRegistration,

        /// <summary>
        /// The Appointment
        /// </summary>
        Appointment,

        /// <summary>
        /// The  Cancel Appointment
        /// </summary>

        CancelAppointment,

        /// <summary>
        /// The  Cancel patient reg
        /// </summary>
        CancelPatientRegistration,

        /// <summary>
        /// The pharmacy sale return
        /// </summary>
        PharmacyReturn,

        /// <summary>
        /// The labs
        /// </summary>
        Labs,

        /// <summary>
        /// The labs cancel
        /// </summary>
        LabsCancel,

        /// <summary>
        /// The Scan Appointment
        /// </summary>
        ScanAppointment,

        /// <summary>
        /// The Scan Appointment Return. 
        /// </summary>
        ScanAppointmentReturn,

        /// <summary>
        /// The Admission Receipt
        /// </summary>
        AdmissionReceipt,

        /// <summary>
        /// The Admission Receipt Refund
        /// </summary>
        AdmissionReceiptRefund,
        Services
    }

    /// <summary>
    /// 
    /// </summary>
    public enum PackageDeleteType
    {
        /// <summary>
        /// The general
        /// </summary>
        General = 1,

        /// <summary>
        /// The product
        /// </summary>
        Product = 2,

        /// <summary>
        /// The surgery
        /// </summary>
        Surgery = 3
    }

    /// <summary>
    /// The receipt type enum
    /// </summary>
    public enum RepeatType
    {
        /// <summary>
        /// The once
        /// </summary>
        Once = 1,

        /// <summary>
        /// The day
        /// </summary>
        Day = 2,

        /// <summary>
        /// The hour
        /// </summary>
        Hour = 3
    }

    /// <summary>
    /// The receipt type enum
    /// </summary>
    public enum AutomaticType
    {
        /// <summary>
        /// The once
        /// </summary>
        BedCharges = 1,

        /// <summary>
        /// The day
        /// </summary>
        DoctorCharges = 2
    }

    /// <summary>
    /// The discount type
    /// </summary>
    public enum DiscountType
    {
        /// <summary>
        /// The discount in amount
        /// </summary>
        DiscountInAmount = 1,

        /// <summary>
        /// The discount in percentage
        /// </summary>
        DiscountInPercentage = 2
    }

    /// <summary>
    /// The module master
    /// </summary>
    //public enum ModulesMaster
    //{
    //    /// <summary>
    //    /// The lab module
    //    /// </summary>
    //    Lab = 1,

    //    /// <summary>
    //    /// The pharmacy module
    //    /// </summary>
    //    Scan = 2,

    //    /// <summary>
    //    /// The scan module
    //    /// </summary>
    //    Pharmacy = 6,

    //    /// <summary>
    //    /// The scan module
    //    /// </summary>
    //    Appointment = 16,

    //    /// <summary>
    //    /// The scan module
    //    /// </summary>
    //    Patient = 17
    //}

    /// <summary>
    /// The module master
    /// </summary>
    public enum BillStatusType
    {
        /// <summary>
        /// The Generated bill
        /// </summary>
        Generated = 1,

        /// <summary>
        /// The not Generated bill
        /// </summary>
        Not_Generated = 2

    }

    /// <summary>
    /// The action type.
    /// </summary>
    public enum ActionType
    {
        QM_CheckIn = 1,
        QM_Start = 2,
        QM_Complete = 3,
    }

    /// <summary>
    /// The module master
    /// </summary>
    public enum GatePassType
    {
        /// <summary>
        /// The Generated bill
        /// </summary>
        Provisional = 1,

        /// <summary>
        /// The not Generated bill
        /// </summary>
        Final = 2

    }
}
