﻿namespace Hims.Domain.Entities.Labs
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The lab main detail template
    /// </summary>
    public class LabMainDetailTemplate
    {
        /// <summary>
        /// Gets or sets the lab main detail template identifier.
        /// </summary>
        /// <value>
        /// The lab main detail template identifier.
        /// </value>
        [Key,Identity]
        public long LabMainDetailTemplateId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int Priority { get; set; }
    }
}
