﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The appointment transaction model.
    /// </summary>
    public class AppointmentTransactionModel
    {
        /// <summary>
        /// Gets or sets the appointment transaction id.
        /// </summary>
        public int AppointmentTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string EncryptedAppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the coupon id.
        /// </summary>
        public int? CouponId { get; set; }

        /// <summary>
        /// Gets or sets the amount.
        /// </summary>
        public decimal Amount { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public decimal Discount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public decimal Total { get; set; }

        /// <summary>
        /// Gets or sets the Transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the transaction.
        /// </summary>
        public string Transaction { get; set; }

        /// <summary>
        /// Gets or sets the transaction date.
        /// </summary>
        public DateTime TransactionDate { get; set; }

        /// <summary>
        /// Gets or sets the bank reference.
        /// </summary>
        public string BankReference { get; set; }

        /// <summary>
        /// Gets or sets the bank code.
        /// </summary>
        public string BankCode { get; set; }

        /// <summary>
        /// Gets or sets the currency symbol.
        /// </summary>
        public char CurrencySymbol { get; set; }

        /// <summary>
        /// Gets or sets the patient country id.
        /// </summary>
        public int PatientCountryId { get; set; }

        /// <summary>
        /// Gets or sets the patient country code.
        /// </summary>
        public string PatientCountryCode { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the payment id.
        /// </summary>
        public int PaymentId { get; set; }

        /// <summary>
        /// Gets or sets the payment mode id.
        /// </summary>
        public int PaymentModeId { get; set; }

        /// <summary>
        /// Gets or sets the payment gateway.
        /// </summary>
        public string PaymentGateway { get; set; }

        /// <summary>
        /// Gets or sets the tds amount.
        /// </summary>
        public decimal? TDSAmount { get; set; }

        /// <summary>
        /// Gets or sets the app charges.
        /// </summary>
        public decimal? AppCharges { get; set; }

        /// <summary>
        /// Gets or sets the refund id.
        /// </summary>
        public int? RefundId { get; set; }

        /// <summary>
        /// Gets or sets the payout id.
        /// </summary>
        public int? PayoutId { get; set; }

        /// <summary>
        /// Gets or sets the payment status id.
        /// </summary>
        public int? PaymentStatusId { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public string PaymentStatusName { get; set; }

        /// <summary>
        /// Gets or sets the settled amount.
        /// </summary>
        public decimal? SettledAmount { get; set; }

        /// <summary>
        /// Gets or sets the settled date.
        /// </summary>
        public DateTime? SettledDate { get; set; }

        /// <summary>
        /// Gets or sets the final amount.
        /// </summary>
        public decimal FinalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total final amount.
        /// </summary>
        public decimal TotalFinalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total settled amount.
        /// </summary>
        public decimal? TotalSettledAmount { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public string PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the email.
        /// </summary>
        public string Email { get; set; }

        /// <summary>
        /// Gets or sets the appointment date.
        /// </summary>
        public DateTime AppointmentDate { get; set; }

        /// <summary>
        /// Gets or sets the week total.
        /// </summary>
        public int WeekTotal { get; set; }

        /// <summary>
        /// Gets or sets the week no.
        /// </summary>
        public int Week { get; set; }

        /// <summary>
        /// Gets or sets the year.
        /// </summary>
        public int Year { get; set; }

        /// <summary>
        /// Gets or sets the appointment time.
        /// </summary>
        public TimeSpan AppointmentTime { get; set; }

        /// <summary>
        /// Gets or sets the provider percentage.
        /// </summary>
        public decimal ProviderPercentage { get; set; }

        /// <summary>
        /// Gets or sets the payout.
        /// </summary>
        public string Payout { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the appointment t ime string.
        /// </summary>
        public string AppointmentTimeString { get; set; }

        /// <summary>
        /// Gets or sets the tds.
        /// </summary>
        public decimal? TDS { get; set; }

        /// <summary>
        /// Gets or sets the sum final amount.
        /// </summary>
        public decimal? SumFinalAmount { get; set; }

        /// <summary>
        /// Gets or sets the gst.
        /// </summary>
        public decimal? Gst { get; set; }

        /// <summary>
        /// Gets or sets the pay u fees.
        /// </summary>
        public decimal? PayUFees { get; set; }

        /// <summary>
        /// Gets or sets the processing fees.
        /// </summary>
        public decimal? ProcessingFees { get; set; }

        /// <summary>
        /// Gets or sets the after processing fees.
        /// </summary>
        public decimal? AfterprocessingFees { get; set; }

        /// <summary>
        /// Gets or sets the provider mobile.
        /// </summary>
        public string ProviderMobile { get; set; }

        /// <summary>
        /// Gets or sets the sum of total.
        /// </summary>
        public decimal? SumTotal { get; set; }

        /// <summary>
        /// Gets or sets the min amount.
        /// </summary>
        public decimal? MinTotal { get; set; }

        /// <summary>
        /// Gets or sets the sum of total.
        /// </summary>
        public decimal? MaxTotal { get; set; }

        /// <summary>
        /// Gets or sets the after app charges.
        /// </summary>
        public decimal? AfterAppCharges { get; set; }

        /// <summary>
        /// Gets or sets the sum after app charges.
        /// </summary>
        public decimal? SumAfterAppCharges { get; set; }

        /// <summary>
        /// Gets or sets the salucro status code.
        /// </summary>
        public int SalucroStatusCode { get; set; }

        /// <summary>
        /// Gets or sets the salucro transaction id.
        /// </summary>
        public string SalucroTransactionId { get; set; }
        
        /// <summary>
        /// Gets or sets the status check in progress.
        /// </summary>
        public bool StatusCheckInProgress { get; set; }

        /// <summary>
        /// Gets or sets the receipt area type id.
        /// </summary>
        public int ReceiptAreaTypeId { get; set; }

        /// <summary>
        /// Gets or sets the salucro transaction id.
        /// </summary>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }
    }
}