﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The dental encounter model.
    /// </summary>
    public class DentalEncounterModel
    {
         /// <summary>
        /// Gets or sets the dental encounter id.
        /// </summary>
         public int DentalEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the dental encounter date.
        /// </summary>
        public DateTime DentalEncounterDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the medical history.
        /// </summary>
        public string? MedicalHistory { get; set; }

        /// <summary>
        /// Gets or sets the dental history.
        /// </summary>
        public string? DentalHistory { get; set; }

        /// <summary>
        /// Gets or sets the family history.
        /// </summary>
        public string? FamilyHistory { get; set; }

        /// <summary>
        /// Gets or sets the oral hygiene.
        /// </summary>
        public string? OralHygiene { get; set; }

        /// <summary>
        /// Gets or sets the clinical findings.
        /// </summary>
        public string? ClinicalFindings { get; set; }

        /// <summary>
        /// Gets or sets the diagnosis.
        /// </summary>
        public string? Diagnosis { get; set; }

        /// <summary>
        /// Gets or sets the medications.
        /// </summary>
        public string? Medications { get; set; }

        /// <summary>
        /// Gets or sets the personal habits.
        /// </summary>
        public string? PersonalHabits { get; set; }

        /// <summary>
        /// Gets or sets the chief complaints.
        /// </summary>
        public string? ChiefComplaints { get; set; }

        /// <summary>
        /// Gets or sets the medication comment.
        /// </summary>
        public string? MedicationComment { get; set; }

        /// <summary>
        /// Gets or sets the symptoms.
        /// </summary>
        public string? Symptoms { get; set; }
    }
}
