﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The icd code.
    /// </summary>
    public class ICDCodeModel
    {
        /// <summary>
        /// Gets or sets the ICD code id.
        /// </summary>
        public int ICDCodeId { get; set; }

        /// <summary>Gets or sets the account id.</summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the code.
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string Description { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the is icd code assigned.
        /// </summary>
        public bool? IsAssignedIcdCode { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
    }
}