﻿#nullable enable
namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The auditLog.
    /// </summary>
    public class InventoryLogModel
    {
        /// <summary>
        /// Gets or sets the pharmacyLog id.
        /// </summary>
        public int InventoryLogId { get; set; }

        /// <summary>
        /// Gets or sets the Pharmacy Log type.
        /// </summary>
        public int InventoryLogTypeId { get; set; }

        /// <summary>
        /// Gets or sets the log type name.
        /// </summary>
        public string? LogTypeName { get; set; }

        /// <summary>
        /// Gets or sets the log date.
        /// </summary>
        public DateTime LogDate { get; set; }

        /// <summary>
        /// Gets or sets the app type.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int? AccountId { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        public string? FullName { get; set; }

        /// <summary>
        /// Gets or sets the role name.
        /// </summary>
        public string? RoleName { get; set; }

        /// <summary>
        /// Gets or sets the pharmacyLog code.
        /// </summary>
        public string LogDescription { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int TotalItems { get; set; }
    }
}