﻿#nullable enable
namespace Hims.Shared.UserModels.PayU
{
    using System.Collections.Generic;

    /// <summary>
    /// The Account data
    /// </summary>
    public class Data
    {
        /// <summary>
        /// Gets or sets merchantId
        /// </summary>
        public long? PayoutMerchantId { get; set; }

        /// <summary>
        /// Gets or sets uuid
        /// </summary>
        public string? Uuid { get; set; }

        /// <summary>
        /// Gets or sets Virtual account number
        /// </summary>
        public string? VirtualAccountNumber { get; set; }

        /// <summary>
        /// Gets or sets transferable amount
        /// </summary>
        public object? TransferableAmount { get; set; }

        /// <summary>
        /// Gets or sets balance amount
        /// </summary>
        public object? Balance { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether low balance.
        /// </summary>
        public bool LowBalance { get; set; }

        /// <summary>
        /// Gets or sets IFSC code
        /// </summary>
        public string? Ifsc { get; set; }

        /// <summary>
        /// Gets or sets type
        /// </summary>
        public string? Type { get; set; }

        /// <summary>
        /// Gets or sets the link.
        /// </summary>
        public string? Link { get; set; }

        /// <summary>
        /// Gets or sets the link id.
        /// </summary>
        public string? LinkId { get; set; }

        /// <summary>
        /// Gets or sets the merchant ref id.
        /// </summary>
        public object? MerchantRefId { get; set; }

        /// <summary>
        /// Gets or sets the no of pages.
        /// </summary>
        public int? NoOfPages { get; set; }

        /// <summary>
        /// Gets or sets the total elements.
        /// </summary>
        public int? TotalElements { get; set; }

        /// <summary>
        /// Gets or sets the current page.
        /// </summary>
        public int? CurrentPage { get; set; }

        /// <summary>
        /// Gets or sets the transaction details.
        /// </summary>
        public IList<TransactionDetail>? TransactionDetails { get; set; }
    }
}