﻿namespace Hims.Shared.UserModels.ProviderMedication
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The provider medication group model.
    /// </summary>
    public class ProviderMedicationGroupModel
    {
        /// <summary>
        /// Gets or sets the provider medication group identifier.
        /// </summary>
        /// <value>
        /// The provider medication group identifier.
        /// </value>        
        public int ProviderMedicationGroupId { get; set; }

        /// <summary>
        /// Gets or sets the name of the tag.
        /// </summary>
        /// <value>
        /// The name of the tag.
        /// </value>
        public string TagName { get; set; }

        /// <summary>
        /// Gets or sets the provider ids.
        /// </summary>
        /// <value>
        /// The provider ids.
        /// </value>
        public string ProviderIds { get; set; }

        /// <summary>
        /// Gets or sets the specialization identifier.
        /// </summary>
        /// <value>
        /// The specialization identifier.
        /// </value>
        public int? SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the name of the specialization.
        /// </summary>
        /// <value>
        /// The name of the specialization.
        /// </value>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets the medicines.
        /// </summary>
        /// <value>
        /// The medicines.
        /// </value>
        public List<ProviderMedicationMasterModel> Medicines { get; set; }
        /// <summary>
        /// Gets or sets the login role identifier.
        /// </summary>
        /// <value>
        /// The login role identifier.
        /// </value>
        public short? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }
    }
}
