﻿using System;

namespace Hims.Shared.UserModels.Telemedicine
{
    /// <summary>
    /// The modify patient request.
    /// </summary>
    public class TelemedicineHistoryModel
    {
        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the full name.
        /// </summary>
        /// <value>
        /// The full name.
        /// </value>
        public string FullName { get; set; }

        /// <summary>
        /// Gets or sets the name of the role.
        /// </summary>
        /// <value>
        /// The name of the role.
        /// </value>
        public string RoleName { get; set; }

        /// <summary>
        /// Gets or sets the full name of the opponent.
        /// </summary>
        /// <value>
        /// The full name of the opponent.
        /// </value>
        public string OpponentFullName { get; set; }

        /// <summary>
        /// Gets or sets the name of the opponent role.
        /// </summary>
        /// <value>
        /// The name of the opponent role.
        /// </value>
        public string OpponentRoleName { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        /// <value>
        /// The appointment no.
        /// </value>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets the payload.
        /// </summary>
        /// <value>
        /// The payload.
        /// </value>
        public string Payload { get; set; }

        /// <summary>
        /// Gets or sets the note.
        /// </summary>
        /// <value>
        /// The note.
        /// </value>
        public string Note { get; set; }

        /// <summary>
        /// Gets or sets the start date.
        /// </summary>
        /// <value>
        /// The start date.
        /// </value>
        public DateTime StartDate { get; set; }

        /// <summary>
        /// Gets or sets the end date.
        /// </summary>
        /// <value>
        /// The end date.
        /// </value>
        public DateTime EndDate { get; set; }

        /// <summary>
        /// Gets or sets the telemedicine identifier.
        /// </summary>
        /// <value>
        /// The telemedicine identifier.
        /// </value>
        public int TelemedicineId { get; set; }
    }
}