﻿namespace Hims.Domain.Entities.Labs
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    public class Machine
    {
        /// <summary>
        /// Gets or sets the MachineId
        /// </summary>
        /// <value>
        /// The Machine Identifier.
        /// </value>
        [Key, Identity]
        public int MachineId { get; set; }

        /// <summary>
        /// Gets or sets the machine code
        /// </summary>
        /// <value>
        /// The Machine Code
        /// </value>
        public string MachineCode { get; set; }

        /// <summary>
        /// Gets or sets the machine Name
        /// </summary>
        /// <value>
        /// The name of the machine
        /// </value>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the Created By
        /// <value>
        /// The Created By.
        /// </value>
        public int CreatedBy { get; set; }
        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }
        /// <summary>
        /// Gets or sets the Modified By
        /// The Modified  By.
        /// </value>
        public int? ModifiedBy { get; set; }
        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public bool Active { get; set; }
        
    }
}
