﻿namespace Hims.Infrastructure.Services
{
    using System;
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Dapper;
    using Domain.Entities;
    using Domain.Repositories.UnitOfWork;
    using Domain.Services;
    using Shared.UserModels.NurseNote;

    /// <inheritdoc />
    public class NurseNoteService : INurseNoteService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IBedService" />
        public NurseNoteService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        /// <inheritdoc />
        public Task<IEnumerable<FetchModel>> FetchAsync(FetchPayload model)
        {
            var query = $@"select a.""FullName"" ""CreatedByName"", n.""Note"", n.""CreatedDate"", n.""AdmissionId"", n.""NurseNoteId"" from ""NurseNote"" n
                        JOIN ""Account"" a on a.""AccountId"" = n.""CreatedBy"" WHERE n.""AdmissionId"" = {model.Id} ";
            return this.unitOfWork.Current.QueryAsync<FetchModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> InsertAsync(InsertModel model)
        {
            var record = new NurseNote
            {
                AdmissionId = model.AdmissionId,
                Note = model.Note,
                CreatedBy = model.CreatedBy,
                CreatedDate = DateTime.Now,
            };

            return await this.unitOfWork.NurseNote.InsertAsync(record);
        }
    }
}