﻿using Dapper;
using Hims.Domain.Entities;
using Hims.Domain.Repositories.UnitOfWork;
using Hims.Domain.Services;
using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Infrastructure.Services
{
    public class PaymentMapHelperService: IPaymentMapHelperService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IPaymentInitiationLogService" />
        public PaymentMapHelperService(IUnitOfWork unitOfWork)
        {
            this.unitOfWork = unitOfWork;
        }

        /// <inheritdoc />
        public Task<PaymentMapHelperModel> FindAsync(int paymentInitiationLogId)
        {
            var query = $@"SELECT * FROM ""PaymentMapHelper""
                                WHERE ""PaymentInitiationLogId""= {paymentInitiationLogId}";
            return this.unitOfWork.Current.QueryFirstOrDefaultAsync<PaymentMapHelperModel>(query);
        }

        /// <inheritdoc />
        public async Task<int> AddAsync(PaymentMapHelperModel model)
        {
            var paymentMapHelperModel = new PaymentMapHelper
            {
                PaymentInitiationLogId =model.PaymentInitiationLogId,
                BillId= (int)model.BillId
            };

            return await this.unitOfWork.PaymentMapHelper.InsertAsync(paymentMapHelperModel);
        }
    }
}
