import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AuthGuard } from '@src/app/shared/guards';
import { NewAmbulanceModulePage } from './ambulance.page';
import { AmbulanceReceiptPage } from './pages/reciept/reciept.page';
import { AmbulanceMasterPage } from './pages/masters/masters.page';
import { AddAmbulancePage } from './pages/masters/add-ambulance/add-ambulance.page';
import { DriverDetailPage } from './pages/masters/driver-detail/driverDetail.page';

const routes: Routes = [
    {
      path: "",
      data: { title: "Ambulance" },
      canActivate: [AuthGuard],
      canActivateChild: [AuthGuard],
      component: NewAmbulanceModulePage,
      children: [
          { path: "", redirectTo: "ambulance-receipt", pathMatch: "full" },
          { path: "ambulance-receipt", component: AmbulanceReceiptPage, data: { title: "Ambulance Receipts" } },
          {
              path: "masters",
              component: AmbulanceMasterPage,
              children: [
                  { path: "add-ambulance", component: AddAmbulancePage, data: { title: "Add Ambulance" } },
                  { path: "driver-detail", component: DriverDetailPage, data: { title: "Driver Detail" } },
                  { path: "**", redirectTo: "add-ambulance" }
              ]
          },
          { path: "**", redirectTo: "ambulance-receipt" }
      ]
  }
]

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class AmbulanceRoutingModule { }