﻿namespace Hims.Shared.UserModels.Labs
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The lab template model.
    /// </summary>
    public class LabTemplateModel
    {
        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>        
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the name of the template.
        /// </summary>
        /// <value>
        /// The name of the template.
        /// </value>
        public string TemplateName { get; set; }

        /// <summary>
        /// Gets or sets the template identifier.
        /// </summary>
        /// <value>
        /// The template identifier.
        /// </value>
        public string TemplateId { get; set; }

        /// <summary>
        /// Gets or sets the joined.
        /// </summary>
        /// <value>
        /// The joined.
        /// </value>
        public string Joined { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabTemplateModel"/> is active.
        /// </summary>
        /// <value>
        ///   <c>true</c> if active; otherwise, <c>false</c>.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the modified by.
        /// </summary>
        /// <value>
        /// The name of the modified by.
        /// </value>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the components.
        /// </summary>
        /// <value>
        /// The parameters.
        /// </value>
        public List<LabTemplateDetailModel> Components { get; set; }

        /// <summary>
        /// Gets or sets the component count.
        /// </summary>
        /// <value>
        /// The component count.
        /// </value>
        public int ComponentCount { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string Term { get; set; }

        /// <summary>
        /// Gets or sets the is method.
        /// </summary>
        /// <value>
        /// The is method.
        /// </value>
        public bool? IsMethod { get; set; }

        /// <summary>
        /// Gets or sets the method text.
        /// </summary>
        /// <value>
        /// The method text.
        /// </value>
        public string MethodText { get; set; }

        /// <summary>
        /// Gets or sets the is interpretation.
        /// </summary>
        /// <value>
        /// The is interpretation.
        /// </value>
        public bool? IsInterpretation { get; set; }

        /// <summary>
        /// Gets or sets the interpretation text.
        /// </summary>
        /// <value>
        /// The interpretation text.
        /// </value>
        public string InterpretationText { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }
    }

    /// <summary>
    /// The lab template detail model.
    /// </summary>
    public class LabTemplateDetailModel
    {
        /// <summary>
        /// Gets or sets the lab template detail identifier.
        /// </summary>
        /// <value>
        /// The lab template detail identifier.
        /// </value>
        public int LabTemplateDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab template header identifier.
        /// </summary>
        /// <value>
        /// The lab template header identifier.
        /// </value>
        public int LabTemplateHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab component header identifier.
        /// </summary>
        /// <value>
        /// The lab component header identifier.
        /// </value>
        public int? LabComponentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the lab parameter header identifier.
        /// </summary>
        /// <value>
        /// The lab parameter header identifier.
        /// </value>
        public int? LabParameterHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the priority.
        /// </summary>
        /// <value>
        /// The priority.
        /// </value>
        public int Priority { get; set; }

        /// <summary>
        /// Gets or sets the name of the component.
        /// </summary>
        /// <value>
        /// The name of the component.
        /// </value>
        public string ComponentName { get; set; }

        /// <summary>
        /// Gets or sets the display name.
        /// </summary>
        /// <value>
        /// The display name.
        /// </value>
        public string DisplayName { get; set; }

        /// <summary>
        /// Gets or sets the name of the parameter.
        /// </summary>
        /// <value>
        /// The name of the parameter.
        /// </value>
        public string ParameterName { get; set; }

        /// <summary>
        /// Gets or sets the component identifier.
        /// </summary>
        /// <value>
        /// The component identifier.
        /// </value>
        public string ComponentId { get; set; }
    }
}
