﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.NeonatalIPEncounter
{
#nullable enable
   
        using System;
        using System.ComponentModel.DataAnnotations;
        using global::Hims.Shared.Library.Enums;
        using Hims.Shared.Library.Enums;
        using Shared.Dapper.Attributes;

        /// <summary>
        /// The encounter.
        /// </summary>
        public class InsertModel
        {
            /// <summary>
            /// Gets or sets the pediatric encounter id.
            /// </summary>
            public int NeonatalIPEncounterId { get; set; }

            /// <summary>
            /// Gets or sets the appointment id.
            /// </summary>
            public int AppointmentId { get; set; }

            /// <summary>
            /// Gets or sets the patient id.
            /// </summary>
            public int PatientId { get; set; }

            /// <summary>
            /// Gets or sets the admission identifier.
            /// </summary>
            /// <value>
            /// The admission identifier.
            /// </value>
            public int? AdmissionId { get; set; }
            /// <summary>
            /// Gets or sets the login role Id.
            /// </summary>
            /// <value>
            /// The admission identifier.
            /// </value>
            public int LoginRoleId { get; set; }
            /// <summary>
            /// Gets or sets the encounter date.
            /// </summary>
            public DateTime PediatricEncounterDate { get; set; }
            /// <summary>
            /// Gets or sets a value indicating whether active.
            /// </summary>
            public bool Active { get; set; }

            /// <summary>
            /// Gets or sets the created by.
            /// </summary>
            public int CreatedBy { get; set; }

            /// <summary>
            /// Gets or sets the created date.
            /// </summary>
            public DateTime CreatedDate { get; set; }

            /// <summary>
            /// Gets or sets the modified by.
            /// </summary>
            public int ModifiedBy { get; set; }

            /// <summary>
            /// Gets or sets the modified date.
            /// </summary>
            public DateTime? ModifiedDate { get; set; }

            /// <summary>
            /// Gets or sets the isadmission.
            /// </summary>
            public bool IsAdmission { get; set; }

            /// <summary>
            /// Gets or sets the json string.
            /// </summary>
            public string JsonString { get; set; }

            /// <summary>
            /// Gets or sets the encounter type.
            /// </summary>
            public NeonatalEncounterType Type { get; set; }
        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string NeonatalBaby { get; set; }



    }
}

