﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The pharmacy sale bill.
    /// </summary>
    public class PharmacySaleBill
    {
        /// <summary>
        /// Gets or sets the pharmacy sale detail id.
        /// </summary>
        public int? PharmacySaleDetailId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy sale header id.
        /// </summary>
        public int? PharmacySaleHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the sale return header id.
        /// </summary>
        public int? SaleReturnHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the serial num.
        /// </summary>
        public int? SerialNum { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int? TaxId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        public int? PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int? Quantity { get; set; }

        /// <summary>
        /// Gets or sets the return quantity.
        /// </summary>
        public int? ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int? AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the totalAmount.
        /// </summary>
        public double? TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the total.
        /// </summary>
        public double? Total { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double? Mrp { get; set; }

        /// <summary>
        /// Gets or sets the paid amount.
        /// </summary>
        /// <value>
        /// The paid amount.
        /// </value>
        public double? PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the tax amount.
        /// </summary>
        public double? TaxAmount { get; set; }

        /// <summary>
        /// Gets or sets the discount per item.
        /// </summary>
        public double? DiscountPerItem { get; set; }

        /// <summary>
        /// Gets or sets the discount.
        /// </summary>
        public double? Discount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        public double? NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double? OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the overall taxes.
        /// </summary>
        public double? OverallTaxes { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double? OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the bill type.
        /// </summary>
        public string BillType { get; set; }

        /// <summary>
        /// Gets or sets the bill number.
        /// </summary>
        public string BillNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the sale date.
        /// </summary>
        public DateTime? SaleDate { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the tax percentage.
        /// </summary>
        public string TaxPercentage { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the Payment  type.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the medicine type
        /// </summary>
        public string MedicineType { get; set; }

        /// <summary>
        /// Gets or sets the surgery kit headerId
        /// </summary>
        public int? SurgeryKitHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the surgery kit name
        /// </summary>
        public string KitName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public string FromDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the optional text 2.
        /// </summary>
        public string ToDate { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? RetailPharmacyId { get; set; }

        /// <summary>
        /// Gets or sets the Payment  type.
        /// </summary>
        public string RetailName { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the payType id.
        /// </summary>
        public int? PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        public string PaymentNumber { get; set; }
        /// <summary>
        /// Gets or sets the HSNCode.
        /// </summary>
        public string HSNCode { get; set; }

        /// <summary>
        /// Gets or sets the patient first name.
        /// </summary>
        public string FirstName { get; set; }
        /// <summary>
        /// Gets or sets the patient middle name.
        /// </summary>
        public string LastName { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public string MiddleName { get; set; }

        /// <summary>
        /// Gets or sets the patient dob.
        /// </summary>
        public DateTime? DateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public string CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public string Role { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public int AccountId { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public double TotalGST { get; set; }
        /// <summary>
        /// Gets or sets the patient last name.
        /// </summary>
        public bool PharmacyBillType { get; set; }

        /// <summary>
        /// Gets or sets the Specialization id.
        /// </summary>
        public int SpecializationId { get; set; }

        /// <summary>
        /// Gets or sets the Specialization name.
        /// </summary>
        public string SpecializationName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is igst.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is igst; otherwise, <c>false</c>.
        /// </value>
        public bool IsIGST { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is SGST.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is SGST; otherwise, <c>false</c>.
        /// </value>
        public bool IsSGST { get; set; }

        /// <summary>
        /// Gets or sets the is salucro bill.
        /// </summary>
        public bool IsSalucroBill { get; set; }

        /// <summary>
        /// Gets or sets the scheduled drug.
        /// </summary>
        /// <value>
        /// The scheduled drug.
        /// </value>
        public string ScheduledDrug { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is general item.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is general item; otherwise, <c>false</c>.
        /// </value>
        public bool IsGeneralItem { get; set; }
        /// <summary>
        /// Gets or sets the scheduled drug.
        /// </summary>
        /// <value>
        /// The scheduled drug.
        /// </value>
        public string ReasonForDiscount { get; set; }

        public double RemovedAmount { get; set; }
    }
}
