﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The laborder value.
    /// </summary>
    public class LabOrderValue
    {
        /// <summary>
        /// Gets or sets the laborder value id.
        /// </summary>
        [Key, Identity]
        public int LabOrderValueId { get; set; }

        /// <summary>Gets or sets the order code.</summary>
        public string OrderCode { get; set; }

        /// <summary>Gets or sets the code.</summary>
        public string Code { get; set; }

        /// <summary>Gets or sets the name.</summary>
        public string Name { get; set; }

        /// <summary>Gets or sets the test.</summary>
        public string Test { get; set; }

        /// <summary>Gets or sets the lab order id.</summary>
        public int LabOrderId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        [IgnoreUpdate]
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        [IgnoreUpdate]
        public DateTime CreatedDate { get; set; }

        /// <summary>Gets or sets the modified by.</summary>
        public int? ModifiedBy { get; set; }

        /// <summary>Gets or sets the modified date.</summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
