﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy issue header.
    /// </summary>
    public class PharmacyIssueHeader
    {
        /// <summary>
        /// Gets or sets the pharmacy issue header id.
        /// </summary>
        [Key, Identity]
        public int PharmacyIssueHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy indent header id.
        /// </summary>
        public int? PharmacyIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the operation indent header identifier.
        /// </summary>
        /// <value>
        /// The operation indent header identifier.
        /// </value>
        public int? OperationIndentHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall gst.
        /// </summary>
        public double OverallGst { get; set; }

        /// <summary>
        /// Gets or sets the overall total.
        /// </summary>
        public double OverallTotal { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }
    }
}
