﻿namespace Hims.Domain.Entities
{
    using System;
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The pharmacy retail stock.
    /// </summary>
    public class PharmacyRetailStock
    {
        /// <summary>
        /// Gets or sets the pharmacy retail stock id.
        /// </summary>
        [Key, Identity]
        public int PharmacyRetailStockId { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }

        /// <summary>
        /// Gets or sets the tax id.
        /// </summary>
        public int TaxId { get; set; }

        /// <summary>
        /// Gets or sets the quantity in.
        /// </summary>
        public int QuantityIn { get; set; }

        /// <summary>
        /// Gets or sets the quantity out.
        /// </summary>
        public int QuantityOut { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy stock id.
        /// </summary>
        public int? PharmacyStockId { get; set; }

        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the expiry date.
        /// </summary>
        public DateTime? ExpiryDate { get; set; }

        /// <summary>
        /// Gets or sets the purchase rate.
        /// </summary>
        public double PurchaseRate { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether is added directly.
        /// </summary>
        public bool IsAddedDirectly { get; set; }

        /// <summary>
        /// Gets or sets the manually updated.
        /// </summary>
        public int ManuallyUpdated { get; set; }
        
        /// <summary>
        /// Gets or sets the retail ware house link identifier.
        /// </summary>
        /// <value>
        /// The retail ware house link identifier.
        /// </value>
        public int RetailWareHouseLinkId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is igst.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is igst; otherwise, <c>false</c>.
        /// </value>
        public bool IsIGST { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is SGST.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is SGST; otherwise, <c>false</c>.
        /// </value>
        public bool IsSGST { get; set; }
    }
}
