﻿namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;

    using Hims.Shared.Dapper.Attributes;

    /// <summary>
    /// The surgery kit detail.
    /// </summary>
    public class SurgeryKitDetail
    {
        /// <summary>
        /// Gets or sets the surgery kit detail id.
        /// </summary>
        [Key, Identity]
        public int SurgeryKitDetailId { get; set; }

        /// <summary>
        /// Gets or sets the surgery kit header id.
        /// </summary>
        public int SurgeryKitHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }
    }
}
