﻿#nullable enable
namespace Hims.Domain.Entities
{
    using System.ComponentModel.DataAnnotations;
    using Shared.Dapper.Attributes;

    /// <summary>
    /// The video call history.
    /// </summary>
    public class VideoCallHistory
    {
        /// <summary>
        /// Gets or sets the video call history id.
        /// </summary>
        [Key, Identity]
        public int VideoCallHistoryId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets the doctor device details id.
        /// </summary>
        public int DoctorDeviceDetailsId { get; set; }

        /// <summary>
        /// Gets or sets the patient device details id.
        /// </summary>
        public int PatientDeviceDetailsId { get; set; }
    }
}