﻿namespace Hims.Domain.Helpers
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Hims.Domain.Entities;
    using IdentityModel.Client;
    using Shared.Library.Enums;

    /// <summary>
    /// The AuthHelper interface.
    /// </summary>
    public interface IAuthHelper
    {
        /// <summary>
        /// The get auth server async.
        /// </summary>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<DiscoveryDocumentResponse> GetIdentityServerAsync();

        /// <summary>
        /// The sign in async.
        /// </summary>
        /// <param name="identityServer">
        /// The identity Server.
        /// </param>
        /// <param name="userName">
        /// The user name.
        /// </param>
        /// <param name="password">
        /// The password.
        /// </param>
        /// <param name="accountTypes">
        /// The account Types.
        /// </param>
        /// <param name="accountId">
        /// The account Id.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<TokenResponse> SignInAsync(DiscoveryDocumentResponse identityServer, string userName, string password, IEnumerable<AccountType> accountTypes, int? accountId);

        /// <summary>
        /// Signs the in alt asynchronous.
        /// </summary>
        /// <param name="identityServer">The identity server.</param>
        /// <param name="userName">Name of the user.</param>
        /// <param name="password">The password.</param>
        /// <param name="roles">The roles.</param>
        /// <param name="accountId">The account identifier.</param>
        /// <returns></returns>
        Task<TokenResponse> SignInAltAsync(DiscoveryDocumentResponse identityServer, string userName, string password, List<int> roles, int? accountId);
        Task<TokenResponse> PatientSignInAsync(DiscoveryDocumentResponse identityServer, string userName, string password, int? accountId);
        /// <summary>
        /// The refresh sign in async.
        /// </summary>
        /// <param name="identityServer">
        /// The identity Server.
        /// </param>
        /// <param name="refreshToken">
        /// The refresh token.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<TokenResponse> RefreshSignInAsync(DiscoveryDocumentResponse identityServer, string refreshToken);

        /// <summary>
        /// The fetch user info async.
        /// </summary>
        /// <param name="identityServer">
        /// The identity Server.
        /// </param>
        /// <param name="accessToken">
        /// The access token.
        /// </param>
        /// <returns>
        /// The <see cref="Task"/>.
        /// </returns>
        Task<UserInfoResponse> FetchUserInfoAsync(DiscoveryDocumentResponse identityServer, string accessToken);
    }
}