﻿namespace Hims.Domain.Services
{
    using System.Collections.Generic;
    using System.Threading.Tasks;
    using Shared.EntityModels;
    using Shared.UserModels.EncounterTemplates;

    /// <summary> 
    /// The encounter template interface.
    /// </summary>
    public interface IEncounterTemplateService
    {

        /// <summary>
        /// Inserts the or edit template asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertOrEditTemplateAsync(EncounterTemplateModel model);

        /// <summary>
        /// Fetches the templates asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<EncounterTemplateModel>> FetchTemplatesAsync(EncounterTemplateModel model);
    }
}
