﻿using Hims.Domain.Entities;
using Hims.Shared.UserModels;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;

namespace Hims.Domain.Services
{
    /// <summary>
    /// The ISessionTypeService.
    /// </summary>
    public interface ISessionTypeService
    {
        /// <summary>
        /// Fetches the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<SessionTypeModel>> FetchAsync(SessionTypeModel model);

        /// <summary>
        /// Modifies the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        //Task<int> ModifyAsync(SessionTypeModel model);

        /// <summary>
        /// Deletes the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> DeleteAsync(SessionTypeModel model);

        /// <summary>
        /// Modifies the status asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> ModifyStatusAsync(SessionTypeModel model);

        /// <summary>
        /// Fetches all session types.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<IEnumerable<SessionType>> FetchAllSessionTypes();
        /// <summary>
        /// Inserts the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> InsertAsync(SessionTypeModel model);
        /// <summary>
        /// Updates the asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        Task<int> UpdateAsync(SessionTypeModel model);
    }
}
