﻿namespace Hims.Infrastructure.Helpers.Middleware
{
    using Domain.Helpers;
    using Microsoft.Extensions.DependencyInjection;

    /// <summary>
    /// The IoC Container configuration.
    /// </summary>
    public static class IocContainerMiddleware
    {
        /// <summary>
        /// The register services.
        /// </summary>
        /// <param name="services">
        /// The services.
        /// </param>
        /// <returns>
        /// The <see cref="IServiceCollection"/>.
        /// </returns>
        public static IServiceCollection RegisterHelpers(this IServiceCollection services)
        {
            services.AddTransient<ICookieHelper, CookieHelper>();
            services.AddTransient<IAESHelper, AESHelper>();
            services.AddTransient<IAuthHelper, AuthHelper>();
            services.AddTransient<IEmailHelper, EmailHelper>();
            services.AddTransient<IShaHelper, ShaHelper>();
            services.AddTransient<ITemplateHelper, TemplateHelper>();
            services.AddTransient<ISMSHelper, SMSHelper>();
            services.AddTransient<IPushNotificationHelper, PushNotificationHelper>();
            services.AddTransient<IDocumentHelper, DocumentHelper>();
            services.AddTransient<IPayUHelper, PayUHelper>();
            services.AddTransient<IKaleyraSMSHelper, KaleyraSMSHelper>();
            services.AddTransient<IURLShortnerHelper, URLShortnerHelper>();
            services.AddTransient<ISalucroHelper, SalucroHelper>();
            services.AddTransient<IFtpHelper, FtpHelper>();
            services.AddTransient<IFtpUploadHelper, FtpUploadHelper>();
            return services;
        }
    }
}