﻿


namespace Hims.Infrastructure.Services
{
    using Dapper;
    using Hims.Domain.Entities;
    using Hims.Domain.Repositories.UnitOfWork;
    using Hims.Domain.Services;
    using Hims.Shared.Library;
    using Hims.Shared.UserModels;
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;

    public class DynamicTemplateConfigService : IDynamicTemplateConfigService
    {
        /// <summary>
        /// The unit of work.
        /// </summary>
        private readonly IUnitOfWork unitOfWork;

        /// <inheritdoc cref="IIdProofService" />
        public DynamicTemplateConfigService(IUnitOfWork unitOfWork) => this.unitOfWork = unitOfWork;

        public async Task<int> ActivateOrDeactivateTest(DynamicTemplateConfigModel model)
        {
            var query = $@"UPDATE ""DynamicTemplateConfig""
	                           SET ""ModifiedBy""={model.CreatedBy}, ""ModifiedDate""=now(), ""Active""= {model.Active}
	                           WHERE ""DynamicTemplateConfigId""= {model.DynamicTemplateConfigId}";
            return await this.unitOfWork.Current.ExecuteAsync(query);
        }

        public async Task<IEnumerable<DynamicTemplateConfigModel>> FetchAllAsync(DynamicTemplateConfigModel model)
        {

            var query = $@"select count(ID.""DynamicTemplateConfigId"") over() as ""TotalItems"", ID.""DynamicTemplateConfigId"", ID.""ReportName"", ID.""Active"", ID.""CreatedBy"", ID.""CreatedDate"",
		                        ID.""ModifiedBy"", ID.""ModifiedDate"", DR.""Name"" as ""TemplateName"", DR.""DynamicReportId"",
		                        C.""FullName"" as ""CreatedByName"", CR.""RoleName"" as ""CreatedByRole"",M.""FullName"" as ""ModifiedByName"", MR.""RoleName"" as ""ModifiedByRole""
                             FROM ""DynamicTemplateConfig"" ID 
                             join ""DynamicReport"" DR on DR.""DynamicReportId""=ID.""DynamicReportId""
                             join ""Account"" C on C.""AccountId"" = ID.""CreatedBy""
                             join ""Role"" CR on CR.""RoleId"" = C.""RoleId""
                             left join ""Account"" M on M.""AccountId"" = ID.""ModifiedBy""
                             left join ""Role"" MR on MR.""RoleId"" = M.""RoleId""
                             order by ID.""CreatedDate"" desc";


            return await this.unitOfWork.Current.QueryAsync<DynamicTemplateConfigModel>(query);
        }

        public async Task<IEnumerable<Resource>> FetchDynamicTemplate()
        {
            var query = $@"select ""DynamicReportId"" as ""Id"", ""Name"" from ""DynamicReport"" ";
            return await this.unitOfWork.Current.QueryAsync<Resource>(query);
        }

        public async Task<IEnumerable<Resource>> FetchTemplateConfigs(GetTemplateConfigs model)
        {
            var names = string.Join(",", model.ReportNames.Select(x => "'" + x + "'"));
            var query = $@"select ""DynamicReportId"" as ""Id"", ""Name"" from ""DynamicReport"" WHERE ""Name"" IN({names}) ";
            return await this.unitOfWork.Current.QueryAsync<Resource>(query);
        }

        public async Task<int> InsertAsync(DynamicTemplateConfigModel model)
        {
            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""DynamicTemplateConfig"" where  lower(""ReportName"") = '{model.ReportName.ToLower()}'");
            if (checkIf > 0)
            {
                return -1;
            }
            var dynamicTemplate = new DynamicTemplateConfig
            {
                ReportName = model.ReportName,
                DynamicReportId = model.DynamicReportId,
                CreatedBy = model.CreatedBy,
                Active = true,
                CreatedDate = DateTime.Now,
            };
            return await this.unitOfWork.DynamicTemplateConfig.InsertAsync(dynamicTemplate);
        }

        public async Task<int> UpdateAsync(DynamicTemplateConfigModel model)
        {


            var checkIf = await this.unitOfWork.Current.QuerySingleOrDefaultAsync<int>($@"select count(*) from ""DynamicTemplateConfig"" where  lower (""ReportName"") = '{model.ReportName.ToLower()}' and ""DynamicTemplateConfigId"" <> {model.DynamicTemplateConfigId}");
            if (checkIf > 0)
            {
                return -1;
            }
            var record = await this.unitOfWork.DynamicTemplateConfig.FindAsync(m => m.DynamicTemplateConfigId == model.DynamicTemplateConfigId);
            if (record == null)
            {
                return -2;
            }
            record.ModifiedBy = model.CreatedBy;
            record.ModifiedDate = DateTime.Now;
            record.ReportName = model.ReportName;
            record.DynamicReportId = model.DynamicReportId;
            return await this.unitOfWork.DynamicTemplateConfig.UpdateAsync(record);



        }
    }
}
