import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AuthGuard } from '@src/app/shared/guards';
import { AdmissionsParentPage } from './admissions.page';
import { AdmissionsViewPage } from './pages/view/view.page';
import { TransferRequestPage } from './pages/transfer-request/transfer-request.page';

// ADMISSIONS
const routes: Routes = [
  {
    path: "",
    data: { title: "Admissions" },
    canActivate: [AuthGuard],
    canActivateChild: [AuthGuard],
    component: AdmissionsParentPage,
    children: [
        { path: "", redirectTo: "view", pathMatch: "full" },
        { path: "view", component: AdmissionsViewPage, data: { title: "Admissions", } },
        { path: "view/:pid", component: AdmissionsViewPage, data: { title: "Admissions", } },
        { path: "view/:pid/:isOpToIp", component: AdmissionsViewPage, data: { title: "Admissions", } },
        { path: "transfer-request", component: TransferRequestPage, data: { title: "Transfer Request", } },
        { path: "**", redirectTo: "view" }
    ]
  }
]

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class AdmissionsRoutingModule { }