import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { CubiclePage } from './pages/cubicle/cubicle.page';
import { MastersPage } from './masters.page';
import { AuthGuard } from '@src/app/shared/guards';
import { AppointmentTypePage } from './pages/appointment-types/appointment-types.page';

const routes: Routes = [
  {
    path: "",
    data: { title: "Masters" },
    canActivate: [AuthGuard],
    canActivateChild: [AuthGuard],
    component: MastersPage,
    children: [
        { path: "", redirectTo: "cubicle", pathMatch: "full" },
        { path: "cubicle", component: CubiclePage, data: { title: "cubicle" } },
        { path: "appointment-types", component: AppointmentTypePage, data: { title: "Appointment Types" } },
        { path: "**", redirectTo: "cubicle" },
    ]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class MastersRoutingModule { }
