﻿import { DragDropModule } from '@angular/cdk/drag-drop';
import { CommonModule } from "@angular/common";
import { HttpClientModule } from "@angular/common/http";
import { NgModule } from "@angular/core";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { NgbDateAdapter, NgbDateParserFormatter, NgbModule } from "@ng-bootstrap/ng-bootstrap";
import { NgIdleModule } from "@ng-idle/core";
import { NgSelectModule } from "@ng-select/ng-select";
import { LoadingBarModule } from "@ngx-loading-bar/core";
import { LoadingBarRouterModule } from "@ngx-loading-bar/router";
import { DateParserFormatter, NgbUTCStringAdapter } from "@shared/formatters";
import { MomentModule } from "ngx-moment";
import { ToastrModule } from "ngx-toastr";
import { NgxPrintModule } from "ngx-print";

@NgModule({
    imports: [
        CommonModule,
        FormsModule,
        ReactiveFormsModule,
        HttpClientModule,
        LoadingBarRouterModule,
        LoadingBarModule,
        NgbModule,
        NgSelectModule,
        NgIdleModule.forRoot(),
        MomentModule.forRoot(),
        NgxPrintModule,
        ToastrModule.forRoot({
            timeOut: 2000,
            positionClass: "toast-bottom-right",
            preventDuplicates: true,
            closeButton: true,
            autoDismiss: true,
            progressBar: true,
            progressAnimation: "increasing",
        }),
        DragDropModule
    ],
    providers: [
        { provide: NgbDateAdapter, useClass: NgbUTCStringAdapter },
        { provide: NgbDateParserFormatter, useClass: DateParserFormatter }
    ],
    exports: [
        CommonModule,
        FormsModule,
        ReactiveFormsModule,
        HttpClientModule,
        LoadingBarRouterModule,
        LoadingBarModule,
        NgbModule,
        NgSelectModule,
        NgIdleModule,
        MomentModule,
        ToastrModule,
        DragDropModule,
        NgxPrintModule
    ]
})
export class SharedCommonModule {
}