﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The company model.
    /// </summary>
    public class CompanyModel
    {
        /// <summary>
        /// Gets or sets the company id.
        /// </summary>
        public int CompanyId { get; set; }       

        /// <summary>
        /// Gets or sets the name.
        /// </summary>
        public string Name { get; set; }

        /// <summary>
        /// Gets or sets the location.
        /// </summary>
        public string Location { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the type of.
        /// </summary>
        public string TypeOf { get; set; }

        /// <summary>
        /// Gets or sets the login Account value id.
        /// </summary>
        public int? LoginAccountId { get; set; }

        /// <summary>
        /// Gets or sets the login Role value id.
        /// </summary>
        public int? LoginRoleId { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the FromDate.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the Todate.
        /// </summary>
        public string ToDate { get; set; }
    }
}
