﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The Refund.
    /// </summary>
    public class RefundModel
    {
        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the Transaction id.
        /// </summary>
        public string TransactionId { get; set; }

        /// <summary>
        /// Gets or sets the AppointmentTransaction id.
        /// </summary>
        public int AppointmentTransactionId { get; set; }

        /// <summary>
        /// Gets or sets the Refund Amount id.
        /// </summary>
        public long RefundAmount { get; set; }

        /// <summary>
        /// Gets or sets the payment id.
        /// </summary>
        public int PaymentId { get; set; }

        /// <summary>
        /// Gets or sets the Refund Status.
        /// </summary>
        public string RefundStatus { get; set; }

        /// <summary>
        /// Gets or sets the Refund completed Date.
        /// </summary>
        public DateTime? RefundCompletedDate { get; set; }

        /// <summary>
        /// Gets or sets the Refund completed Date.
        /// </summary>
        public DateTime? RefundCreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the Refund transaction id.
        /// </summary>
        public int RefundTransactionId { get; set; }

        /// <summary>
        /// Gets or sets total items
        /// </summary>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the appointment no.
        /// </summary>
        public string AppointmentNo { get; set; }

        /// <summary>
        /// Gets or sets total
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }
    }
}
