﻿namespace Hims.Shared.EntityModels
{
    using System;

    /// <summary>
    /// The coupon.
    /// </summary>
    public class RoomModel
    {
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int RoomId { get; set; }
        /// <summary>
        /// Gets or sets Beds count in a room.
        /// </summary>
        public int BedsCount { get; set; }
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int BedId { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int WardId { get; set; }
        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string RoomName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the coupon code.
        /// </summary>
       // public int RoomRent { get; set; }


        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        public int? TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the floor id.
        /// </summary>
        public int FloorId { get; set; }

        /// <summary>
        /// Gets or sets the floorname code.
        /// </summary>
        public string? FloorName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the bed status.
        /// </summary>
        /// <value>
        /// The name of the bed status.
        /// </value>
        public string? BedStatusName { get; set; }

        /// <summary>
        /// Gets or sets the created by role.
        /// </summary>
        /// <value>
        /// The created by role.
        /// </value>
        public string? CreatedByRole { get; set; }

        /// <summary>
        /// Gets or sets the modified by role.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string? ModifiedByRole { get; set; }

        /// <summary>
        /// Gets or sets the ot room identifier.
        /// </summary>
        /// <value>
        /// The ot room identifier.
        /// </value>
        public int OTRoomId { get; set; }

        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary> RoomRent
        public int RoomRent { get; set; }

        /// <summary>
        /// Gets or sets the  charge category name.
        /// </summary>
        /// <value>
        /// The modified by role.
        /// </value>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string LocationName { get; set; }
        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string SurgeryId { get; set; }
        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public string SurgeryName { get; set; }
        /// <summary>
        /// Gets or sets the allowed account identifier.
        /// </summary>
        /// <value>
        /// The allowed account identifier.
        /// </value>
        public string PerformedTestId { get; set; }
        /// <summary>
        /// Gets or sets the location name.
        /// </summary>
        public int LocationId { get; set; }
        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary>
        public int? ChargeCategoryId { get; set; }
        /// <summary>
        /// Gets or sets the charge category id.
        /// </summary>
        public int? Id { get; set; }        
    }
}
