﻿namespace Hims.Shared.UserModels
{
    using Microsoft.AspNetCore.Http;
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The appointment.
    /// </summary>
    public class ModifyAdmissionModel
    {
        /// <summary>
        /// Gets or sets the admission id.
        /// </summary>
        public int AdmissionId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted admission id.
        /// </summary>
        public string EncryptedAdmissionId { get; set; }
        /// <summary>
        /// Gets or sets the wardid.
        /// </summary>
        public string? FloorName { get; set; }
        /// <summary>
        /// Gets or sets the discharge id.
        /// </summary>
        public int? DischargeId { get; set; }

        /// <summary>
        /// Gets or sets the admission no.
        /// </summary>
        public string AdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        public DateTime AdmissionDate { get; set; }

        /// <summary>
        /// Gets or sets the admission time.
        /// </summary>
        public TimeSpan? AdmissionTime { get; set; }

        /// <summary>
        /// Gets or sets the admission time string.
        /// </summary>
        public string AdmissionTimeString { get; set; }

        /// <summary>
        /// Gets or sets the provider id.
        /// </summary>
        public int ProviderId { get; set; }

        /// <summary>
        /// Gets or sets the doctor unit master identifier.
        /// </summary>
        /// <value>
        /// The doctor unit master identifier.
        /// </value>
        public int DoctorUnitMasterId { get; set; }

        /// <summary>
        /// Gets or sets the provider name.
        /// </summary>
        public string ProviderName { get; set; }

        /// <summary>
        /// Gets or sets the provider gender.
        /// </summary>
        public string ProviderGender { get; set; }
        /// <summary>
        /// Gets or sets the is maternity.
        /// </summary>
        public bool? swap { get; set; }
        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? BedStatusId { get; set; }
        /// <summary>
        /// Gets or sets the provider age.
        /// </summary>
        public int ProviderAge { get; set; }

        /// <summary>
        /// Gets or sets the provider thumbnail url.
        /// </summary>
        public string? ProviderThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the department id.
        /// </summary>
        public int DepartmentId { get; set; }

        /// <summary>
        /// Gets or sets the department name.
        /// </summary>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        public int PatientId { get; set; }

        /// <summary>
        /// Gets or sets the encrypted patient id.
        /// </summary>
        public string EncryptedPatientId { get; set; }

        /// <summary>
        /// Gets or sets the patient family member name.
        /// </summary>
        public string? FamilyMemberName { get; set; }

        /// <summary>
        /// Gets or sets the patient relation with family member.
        /// </summary>
        public string? Relation { get; set; }

        /// <summary>
        /// Gets or sets the patient name.
        /// </summary>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the patient gender.
        /// </summary>
        public string PatientGender { get; set; }

        /// <summary>
        /// Gets or sets the patient mobile.
        /// </summary>
        public string PatientMobile { get; set; }

        /// <summary>
        /// Gets or sets the patient age.
        /// </summary>
        public int PatientAge { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail url.
        /// </summary>
        public string? PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the patient type.
        /// </summary>
        public char? PatientType { get; set; }

        /// <summary>
        /// Gets or sets the ward id.
        /// </summary>
        public int? WardId { get; set; }

        /// <summary>
        /// Gets or sets the room id.
        /// </summary>
        public int? RoomId { get; set; }

        /// <summary>
        /// Gets or sets the bed id.
        /// </summary>
        public int? BedId { get; set; }

        /// <summary>
        /// Gets or sets the ward name.
        /// </summary>
        public string WardName { get; set; }

        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string RoomName { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? BedAssociatedData { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? NRIData { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? SurrogacyData { get; set; }
        /// <summary>
        /// Gets or sets the room name.
        /// </summary>
        public string? EmergencyInfo { get; set; }

        /// <summary>
        /// Gets or sets the bed number.
        /// </summary>
        public string BedNumber { get; set; }

        /// <summary>
        /// Gets or sets the patient family id.
        /// </summary>
        public int? PatientFamilyId { get; set; }

        /// <summary>
        /// Gets or sets the is discharged.
        /// </summary>
        public bool? IsDischarged { get; set; }

        /// <summary>
        /// Gets or sets the is maternity.
        /// </summary>
        public bool? IsMaternity { get; set; }

        /// <summary>
        /// Gets or sets the babys birth date.
        /// </summary>
        public DateTime? BabysBirthDate { get; set; }

        /// <summary>
        /// Gets or sets the babys birth time.
        /// </summary>
        public TimeSpan? BabysBirthTime { get; set; }

        /// <summary>
        /// Gets or sets the babys surgery type.
        /// </summary>
        public int? BabysSurgeryType { get; set; }

        /// <summary>
        /// Gets or sets the babys gender.
        /// </summary>
        public char? BabysGender { get; set; }

        /// <summary>
        /// Gets or sets the babys fathers name.
        /// </summary>
        public string BabysFathersName { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the babys fathers name.
        /// </summary>
        public string BabysMothersAdmissionNo { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the encounter id.
        /// </summary>
        public int? EncounterId { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public string? EncounterType { get; set; }

        /// <summary>
        /// Gets or sets the ready for discharge.
        /// </summary>
        public bool? ReadyforDischarge { get; set; }

        /// <summary>
        /// Gets or sets the admission notes.
        /// </summary>
        public string? AdmissionNotes { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the created by role name.
        /// </summary>
        public string CreatedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by role name.
        /// </summary>
        public string ModifiedByRoleName { get; set; }

        /// <summary>
        /// Gets or sets the surgery type id.
        /// </summary>
        public int? SurgeryTypeId { get; set; }

        /// <summary>
        /// Gets or sets the surgery name.
        /// </summary>
        public string SurgeryName { get; set; }

        /// <summary>
        /// Gets or sets the attendant name
        /// </summary>
        public string? AttendantName { get; set; }

        /// <summary>
        /// Gets or sets the attendant contact no
        /// </summary>
        public string? AttendantContactNo { get; set; }

        /// <summary>
        /// Gets or sets the attendant relation with patient
        /// </summary>
        public string? AttendantRelationWithPatient { get; set; }

        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        public DateTime? DischargeDate { get; set; }

        /// <summary>
        /// Gets or sets the discharge time.
        /// </summary>
        public TimeSpan? DischargeTime { get; set; }

        /// <summary>
        /// Gets or sets the discharge time string.
        /// </summary>
        public string DischargeTimeString { get; set; }

        /// <summary>
        /// Gets or sets the discharge status.
        /// </summary>
        public string DischargeStatus { get; set; }

        /// <summary>
        /// Gets or sets the paid amount.
        /// </summary>
        public decimal? PaidAmount { get; set; }

        /// <summary>
        /// Gets or sets the final amount.
        /// </summary>
        public decimal? FinalAmount { get; set; }

        /// <summary>
        /// Gets or sets the payment status.
        /// </summary>
        public string? PaymentStatus { get; set; }

        /// <summary>
        /// Gets or sets the is final bill.
        /// </summary>
        public bool? IsFinalBill { get; set; }

        /// <summary>
        /// Gets or sets the Log From.
        /// </summary>
        public short LogFrom { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public short TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the UMR number.
        /// </summary>
        public string? UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the internal medicine identifier.
        /// </summary>
        /// <value>
        /// The internal medicine identifier.
        /// </value>
        public int? InternalMedicineId { get; set; }

        /// <summary>
        /// Gets or sets the follow up days for ip.
        /// </summary>
        public int? FollowUpDaysForIp { get; set; }

        /// <summary>
        /// Gets or sets the expected discharge date.
        /// </summary>
        /// <value>
        /// The expected discharge date.
        /// </value>
        public DateTime? ExpectedDischargeDate { get; set; }

        ///// <summary>
        ///// Gets or sets the pending medicines.
        ///// </summary>
        ///// <value>
        ///// The pending medicines.
        ///// </value>
        //public int? PendingMedicines { get; set; }

        ///// <summary>
        ///// Gets or sets the progress report identifier.
        ///// </summary>
        ///// <value>
        ///// The progress report identifier.
        ///// </value>
        //public int? ProgressReportId { get; set; }


        /// <summary>
        /// Gets or sets the DischargeBy (AccountId).
        /// </summary>
        public int? DischargedBy { get; set; }

        /// <summary>
        /// Gets or sets the DischargeByRole (RoleName).
        /// or if  is provider then (DepartmentName)
        /// </summary>
        public string? DischargedByRole { get; set; }

        /// <summary>
        /// Gets or sets the DischargedByName
        /// name of person who updated the discharged date
        /// </summary>
        public string? DischargedByName { get; set; }

        /// <summary>
        /// Gets or sets the visit type id.
        /// </summary>
        public int? VisitTypeId { get; set; }

        /// <summary>
        /// Gets or sets the is converted from op to ip.
        /// </summary>
        public bool? IsConvertedFromOPtoIp { get; set; }

        /// <summary>
        /// Gets or sets the patient priority identifier.
        /// </summary>
        /// <value>
        /// The patient priority identifier.
        /// </value>
        public int? PatientPriorityId { get; set; }

        /// <summary>
        /// Gets or sets the breakfast.
        /// </summary>
        /// <value>
        /// The breakfast.
        /// </value>
        public TimeSpan? Breakfast { get; set; }

        /// <summary>
        /// Gets or sets the lunch.
        /// </summary>
        /// <value>
        /// The lunch.
        /// </value>
        public TimeSpan? Lunch { get; set; }

        /// <summary>
        /// Gets or sets the dinner.
        /// </summary>
        /// <value>
        /// The dinner.
        /// </value>
        public TimeSpan? Dinner { get; set; }

        /// <summary>
        /// Gets or sets the breakfast.
        /// </summary>
        /// <value>
        /// The breakfast.
        /// </value>
        public string BreakfastStr { get; set; }

        /// <summary>
        /// Gets or sets the lunch.
        /// </summary>
        /// <value>
        /// The lunch.
        /// </value>
        public string LunchStr { get; set; }

        /// <summary>
        /// Gets or sets the dinner.
        /// </summary>
        /// <value>
        /// The dinner.
        /// </value>
        public string DinnerStr { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int LocationId { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string? LocationName { get; set; }

        /// <summary>
        /// Gets or sets the service order.
        /// </summary>
        /// <value>
        /// The name of the service order.
        /// </value>
        public int? ServiceOrder { get; set; }

        /// <summary>
        /// Gets or sets the case type id.
        /// </summary>
        /// <value>
        /// The name of the case type id.
        /// </value>
        public int? CaseTypeId { get; set; }

        /// <summary>
        /// Gets or sets the pay type id.
        /// </summary>
        /// <value>
        /// The name of the pay type id.
        /// </value>
        public int? AdmissionPayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the insurance company Id.
        /// </summary>
        /// <value>
        /// The name of the insurance company Id.
        /// </value>
        public int? InsuranceCompanyId { get; set; }

        /// <summary>
        /// Gets or sets the referral doctor Id.
        /// </summary>
        /// <value>
        /// The name of the referral doctor Id.
        /// </value>
        public int? ReferralDoctorId { get; set; }

        /// <summary>
        /// Gets or sets the tpa identifier.
        /// </summary>
        /// <value>
        /// The tpa identifier.
        /// </value>
        public int TpaId { get; set; }

        /// <summary>
        /// Gets or sets the patient organization.
        /// </summary>
        /// <value>
        /// The patient organization.
        /// </value>
        public string? PatientOrganization { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int? ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the admission package identifier.
        /// </summary>
        /// <value>
        /// The admission package identifier.
        /// </value>
        public int? AdmissionPackageId { get; set; }

        /// <summary>
        /// Gets or sets the package module identifier.
        /// </summary>
        /// <value>
        /// The package module identifier.
        /// </value>
        public int? PackageModuleId { get; set; }

        /// <summary>
        /// Gets or sets the admission bed change request identifier.
        /// </summary>
        /// <value>
        /// The admission bed change request identifier.
        /// </value>
        public int? AdmissionBedChangeRequestId { get; set; }

        /// <summary>
        /// Gets or sets the request comments.
        /// </summary>
        /// <value>
        /// The request comments.
        /// </value>
        public string? RequestComments { get; set; }

        /// <summary>
        /// Gets or sets the charge category names.
        /// </summary>
        /// <value>
        /// The charge category names.
        /// </value>
        public string? ChargeCategoryNames { get; set; }

        /// <summary>
        /// Gets or sets the current room identifier.
        /// </summary>
        /// <value>
        /// The current room identifier.
        /// </value>
        public int? CurrentRoomId { get; set; }

        /// <summary>
        /// Gets or sets the name of the current room.
        /// </summary>
        /// <value>
        /// The name of the current room.
        /// </value>
        public string? CurrentRoomName { get; set; }
        public IFormFileCollection? Files { get; set; } = null;
        public List<String>? FilePaths { get; set; }
        /// <summary>
        /// Gets or sets the insurance id.
        /// </summary>
        public string? DocumentName { get; set; }
        /// <summary>
        /// Gets or sets the document type.
        /// </summary>
        public string? DocumentType { get; set; }

        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        public string? Description { get; set; }
        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? ThumbnailUrl { get; set; }
        /// <summary>
        /// Gets or sets the thumbnail url.
        /// </summary>
        public string? DocumentUrl { get; set; } = string.Empty;
        public int? CounsellingId { get; set; }
    }
}
