﻿

namespace Hims.Shared.UserModels
{
    using Hims.Domain.Entities;
    using Hims.Shared.Dapper.Attributes;
    using System;
    using System.Collections.Generic;
    using System.ComponentModel.DataAnnotations;
    using System.Text;
    /// <summary>
    /// The doctor unit model.
    /// </summary>
    public class DoctorUnitMasterModel
    {


        /// <summary>
        /// Gets or sets the tag doctor  identifier.
        /// </summary>
        /// <value>
        /// The tag doctor identifier.
        /// </value>
        public int? DoctorUnitMasterId { get; set; }

        /// <summary>
        /// Gets or sets doctor.
        /// </summary>
        /// <value>
        /// The name of doctor.
        /// </value>
        public string UnitName { get; set; }
        /// <summary>
        /// Gets or sets designation
        /// </summary>
        /// <value>
        ///  the name of designation
        /// </value>
        public string Code { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>

        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>

        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }
        /// <summary>
        /// Gets or sets the locationId.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public int? LocationId { get; set; }
        /// <summary>
        /// Gets or sets the departmentId.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public int? DepartmentId { get; set; }
        /// <summary>
        /// Gets or sets login role id.
        /// </summary>
        /// <value>
        /// The login role id.
        /// </value>

        public int? LoginRoleId { get; set; }
        /// <summary>
        /// Gets or sets created by name.
        /// </summary>
        /// <value>
        /// The created by name.
        /// </value>
        public string? CreatedByName { get; set; }
        /// <summary>
        /// Gets or sets tag doctor.
        /// </summary>
        public List<TagDoctorModel> TagDoctor { get; set; }
        /// <summary>
        /// Gets or sets location.
        /// </summary>
        public string? Location { get; set; }
        /// <summary>
        /// Gets or sets department.
        /// </summary>
        public string? Department { get; set; }
        /// <summary>
        /// Gets or sets modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }
        /// <summary>
        /// Gets or sets modified by name.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets the term.
        /// </summary>
        /// <value>
        /// The term.
        /// </value>
        public string Term { get; set; }
    }
}
