﻿namespace Hims.Shared.UserModels.Filters
{
    using System;

    /// <summary>
    /// The daily sales filters model.
    /// </summary>
    public class DailySalesMedicationFilterModel
    {
        /// <summary>
        /// Gets or sets the from date.
        /// </summary>
        public string FromDate { get; set; }

        /// <summary>
        /// Gets or sets the to date.
        /// </summary>
        public string ToDate { get; set; }

        /// <summary>
        /// Gets or sets the product name.
        /// </summary>
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the generic name.
        /// </summary>
        public string GenericName { get; set; }

        /// <summary>
        /// Gets or sets the category name.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the company name.
        /// </summary>
        public string CompanyName { get; set; }

        /// <summary>
        /// Gets or sets the supplier name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the paid via.
        /// </summary>
        public string PaidVia { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the PayType identifier.
        /// </summary>
        /// <value>
        /// The Pay Type identifier.
        /// </value>
        public int? PayTypeId { get; set; }
    }
}