﻿namespace Hims.Shared.UserModels.Laboratory
{
    using System;
    using System.Collections.Generic;

    /// <summary>
    /// The booking package laboratory model.
    /// </summary>
    public class BookingPackageLaboratoryModel
    {
        /// <summary>
        /// Gets or sets the lab name.
        /// </summary>
        public string LabName { get; set; }

        /// <summary>
        /// Gets or sets the lab code.
        /// </summary>
        public string LabCode { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the lab booking package detail id.
        /// </summary>
        public int LabBookingPackageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking detail id.
        /// </summary>
        public int LabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab header id.
        /// </summary>
        public int LabHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the is report generated.
        /// </summary>
        public bool? IsReportGenerated { get; set; }

        /// <summary>
        /// Gets or sets the report date.
        /// </summary>
        public DateTime? ReportDate { get; set; }

        /// <summary>
        /// Gets or sets the is sample collected.
        /// </summary>
        public bool? IsSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleDate { get; set; }

        /// <summary>
        /// Gets or sets the typed by.
        /// </summary>
        public int? TypedBy { get; set; }

        /// <summary>
        /// Gets or sets the typed date.
        /// </summary>
        public DateTime? TypedDate { get; set; }

        /// <summary>
        /// Gets or sets the typed by name.
        /// </summary>
        public string TypedByName { get; set; }

        /// <summary>
        /// Gets or sets the verified by.
        /// </summary>
        public int? VerifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the verified by name.
        /// </summary>
        public string VerifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the labs parameters.
        /// </summary>
        public List<LabReportParamModel> LabsParameters { get; set; }

   

        /// <summary>
        /// Gets or sets the department name for lab
        /// </summary>
        public string DepartmentName { get; set; }
        
        /// <summary>
        /// Gets or sets the bar code generated name
        /// </summary>
        public string BarcodeGeneratedName { get; set; }

        /// <summary>
        /// Gets or sets the name of sample collector
        /// </summary>
        public string SampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of sample Receiver
        /// </summary>
        public string CollectedSampleReceivedBy { get; set; }

        /// <summary>
        /// Gets or sets the name of the verified by doctor.
        /// </summary>
        /// <value>
        /// The name of the verified by doctor.
        /// </value>
        public string VerifiedByDoctorName { get; set; }


        /// <summary>
        /// Gets or sets the sample date.
        /// </summary>
        public DateTime? SampleReceivedDate { get; set; }

        /// <summary>
        /// Gets or sets the barcode identifier.
        /// </summary>
        /// <value>
        /// The barcode identifier.
        /// </value>

        public bool Barcode { get; set; }

        /// <summary>
        /// Gets or sets the barcode generated by identifier.
        /// </summary>
        /// <value>
        /// The barcode  generated by identifier.
        /// </value>

        public int? BarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the borcode generated date.
        /// </summary>
        /// <value>
        /// The borcode generated date identifier.
        /// </value>

        public DateTime? BarcodeGeneratedDate { get; set; }
    }
}
