﻿using System;
using System.Collections.Generic;
using System.Text;

namespace Hims.Shared.UserModels.Labs
{
    public class NewLabSampleHandlerModel
    {
        /// <summary>
        /// Creates new labbookingheaderid.
        /// </summary>
        /// <value>
        /// The new lab booking header identifier.
        /// </value>
        public int NewLabBookingHeaderId { get; set; }

        /// <summary>
        /// Gets or sets the requisition number.
        /// </summary>
        /// <value>
        /// The requisition number.
        /// </value>
        public string RequisitionNumber { get; set; }

        /// <summary>
        /// Gets or sets the type.
        /// </summary>
        /// <value>
        /// The type.
        /// </value>
        public string Type { get; set; }

        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        /// <value>
        /// The mobile.
        /// </value>
        public string Mobile { get; set; }

        /// <summary>
        /// Gets or sets the name of the doctor.
        /// </summary>
        /// <value>
        /// The name of the doctor.
        /// </value>
        public string DoctorName { get; set; }

        /// <summary>
        /// Gets or sets the patient identifier.
        /// </summary>
        /// <value>
        /// The patient identifier.
        /// </value>
        public int? PatientId { get; set; }

        /// <summary>
        /// Gets or sets the doctor identifier.
        /// </summary>
        /// <value>
        /// The doctor identifier.
        /// </value>
        public int? DoctorId { get; set; }

        /// <summary>
        /// Gets or sets the employee identifier.
        /// </summary>
        /// <value>
        /// The employee identifier.
        /// </value>
        public int? EmployeeId { get; set; }

        /// <summary>
        /// Gets or sets the location identifier.
        /// </summary>
        /// <value>
        /// The location identifier.
        /// </value>
        public int? LocationId { get; set; }

        /// <summary>
        /// Gets or sets the overall discount percentage.
        /// </summary>
        /// <value>
        /// The overall discount percentage.
        /// </value>
        public int? OverallDiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the overall total amount.
        /// </summary>
        /// <value>
        /// The overall total amount.
        /// </value>
        public double OverallTotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the overall discount.
        /// </summary>
        /// <value>
        /// The overall discount.
        /// </value>
        public double? OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the overall net amount.
        /// </summary>
        /// <value>
        /// The overall net amount.
        /// </value>
        public double OverallNetAmount { get; set; }

        /// <summary>
        /// Gets or sets the pay type identifier.
        /// </summary>
        /// <value>
        /// The pay type identifier.
        /// </value>
        public int PayTypeId { get; set; }

        /// <summary>
        /// Gets or sets the payment number.
        /// </summary>
        /// <value>
        /// The payment number.
        /// </value>
        public string PaymentNumber { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        /// <value>
        /// The created date.
        /// </value>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        /// <value>
        /// The modified by.
        /// </value>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        /// <value>
        /// The modified date.
        /// </value>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the active.
        /// </summary>
        /// <value>
        /// The active.
        /// </value>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the name of the created by.
        /// </summary>
        /// <value>
        /// The name of the created by.
        /// </value>
        public string CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the patient thumbnail URL.
        /// </summary>
        /// <value>
        /// The patient thumbnail URL.
        /// </value>
        public string PatientThumbnailUrl { get; set; }

        /// <summary>
        /// Gets or sets the name of the employee.
        /// </summary>
        /// <value>
        /// The name of the employee.
        /// </value>
        public string EmployeeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the pay type.
        /// </summary>
        /// <value>
        /// The name of the pay type.
        /// </value>
        public string PayTypeName { get; set; }

        /// <summary>
        /// Gets or sets the name of the location.
        /// </summary>
        /// <value>
        /// The name of the location.
        /// </value>
        public string LocationName { get; set; }

        /// <summary>
        /// Gets or sets the umr no.
        /// </summary>
        /// <value>
        /// The umr no.
        /// </value>
        public string UMRNo { get; set; }

        /// <summary>
        /// Gets or sets the gender.
        /// </summary>
        /// <value>
        /// The gender.
        /// </value>
        public string Gender { get; set; }

        /// <summary>
        /// Gets or sets the age.
        /// </summary>
        /// <value>
        /// The age.
        /// </value>
        public int? Age { get; set; }

        /// <summary>
        /// Gets or sets the size of the page.
        /// </summary>
        /// <value>
        /// The size of the page.
        /// </value>
        public int? PageSize { get; set; }

        /// <summary>
        /// Gets or sets the index of the page.
        /// </summary>
        /// <value>
        /// The index of the page.
        /// </value>
        public int? PageIndex { get; set; }

        /// <summary>
        /// Gets or sets the total items.
        /// </summary>
        /// <value>
        /// The total items.
        /// </value>
        public int TotalItems { get; set; }

        /// <summary>
        /// Gets or sets from date.
        /// </summary>
        /// <value>
        /// From date.
        /// </value>
        public string FromDate { get; set; }

        /// <summary>
        /// Converts to date.
        /// </summary>
        /// <value>
        /// To date.
        /// </value>
        public string ToDate { get; set; }

        /// <summary>
        /// Creates new labbookingdetailid.
        /// </summary>
        /// <value>
        /// The new lab booking detail identifier.
        /// </value>
        public int NewLabBookingDetailId { get; set; }

        /// <summary>
        /// Gets or sets the lab main detail identifier.
        /// </summary>
        /// <value>
        /// The lab main detail identifier.
        /// </value>
        public int LabMainDetailId { get; set; }

        /// <summary>
        /// Gets or sets the charge category identifier.
        /// </summary>
        /// <value>
        /// The charge category identifier.
        /// </value>
        public int ChargeCategoryId { get; set; }

        /// <summary>
        /// Gets or sets the lab booking status identifier.
        /// </summary>
        /// <value>
        /// The lab booking status identifier.
        /// </value>
        public int? LabBookingStatusId { get; set; }

        /// <summary>
        /// Gets or sets the discount percentage.
        /// </summary>
        /// <value>
        /// The discount percentage.
        /// </value>
        public int? DiscountPercentage { get; set; }

        /// <summary>
        /// Gets or sets the discount amount.
        /// </summary>
        /// <value>
        /// The discount amount.
        /// </value>
        public double? DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the total amount.
        /// </summary>
        /// <value>
        /// The total amount.
        /// </value>
        public double TotalAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount.
        /// </summary>
        /// <value>
        /// The net amount.
        /// </value>
        public double NetAmount { get; set; }

        /// <summary>
        /// Gets or sets the status.
        /// </summary>
        /// <value>
        /// The status.
        /// </value>
        public string Status { get; set; }

        /// <summary>
        /// Gets or sets the name of the test.
        /// </summary>
        /// <value>
        /// The name of the test.
        /// </value>
        public string TestName { get; set; }

        /// <summary>
        /// Gets or sets the test code.
        /// </summary>
        /// <value>
        /// The test code.
        /// </value>
        public string TestCode { get; set; }

        /// <summary>
        /// Gets or sets the name of the department.
        /// </summary>
        /// <value>
        /// The name of the department.
        /// </value>
        public string DepartmentName { get; set; }

        /// <summary>
        /// Gets or sets the name of the charge category.
        /// </summary>
        /// <value>
        /// The name of the charge category.
        /// </value>
        public string ChargeCategoryName { get; set; }

        /// <summary>
        /// Gets or sets the name of the type.
        /// </summary>
        /// <value>
        /// The name of the type.
        /// </value>
        public string TypeName { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection identifier.
        /// </value>
        public int? LabSampleCollectionId { get; set; }

        /// <summary>
        /// Gets or sets the sample collected by.
        /// </summary>
        /// <value>
        /// The sample collected by.
        /// </value>
        public int? SampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the barcode generated by.
        /// </summary>
        /// <value>
        /// The barcode generated by.
        /// </value>
        public int? BarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the collection date.
        /// </summary>
        /// <value>
        /// The collection date.
        /// </value>
        public DateTime? CollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the barcode date.
        /// </summary>
        /// <value>
        /// The barcode date.
        /// </value>
        public DateTime? BarcodeDate { get; set; }

        /// <summary>
        /// Gets or sets the is barcode generated.
        /// </summary>
        /// <value>
        /// The is barcode generated.
        /// </value>
        public bool? IsBarcodeGenerated { get; set; }

        /// <summary>
        /// Gets or sets the name of the sample collected by.
        /// </summary>
        /// <value>
        /// The name of the sample collected by.
        /// </value>
        public string SampleCollectedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the barcode generated by.
        /// </summary>
        /// <value>
        /// The name of the barcode generated by.
        /// </value>
        public string BarcodeGeneratedByName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is show sample collected.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is show sample collected; otherwise, <c>false</c>.
        /// </value>
        public bool? IsShowSampleCollected { get; set; }

        /// <summary>
        /// Gets or sets the color of the row.
        /// </summary>
        /// <value>
        /// The color of the row.
        /// </value>
        public string RowColor { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is external.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is external; otherwise, <c>false</c>.
        /// </value>
        public bool IsExternalLab { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance is internal.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance is internal; otherwise, <c>false</c>.
        /// </value>
        public bool IsInternalLab { get; set; }

        /// <summary>
        /// Gets or sets the comment.
        /// </summary>
        /// <value>
        /// The comment.
        /// </value>
        public string Comment { get; set; }

        /// <summary>
        /// Gets or sets the sample usage.
        /// </summary>
        /// <value>
        /// The sample usage.
        /// </value>
        public string SampleUsage { get; set; }

        /// <summary>
        /// Gets or sets the role identifier.
        /// </summary>
        /// <value>
        /// The role identifier.
        /// </value>
        public int RoleId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [consent form required].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [consent form required]; otherwise, <c>false</c>.
        /// </value>
        public bool ConsentFormRequired { get; set; }

        /// <summary>
        /// Gets or sets the name of the lab vacutainer.
        /// </summary>
        /// <value>
        /// The name of the lab vacutainer.
        /// </value>
        public string LabVacutainerName { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this <see cref="LabSampleHandlerModel"/> is emergency.
        /// </summary>
        /// <value>
        ///   <c>true</c> if emergency; otherwise, <c>false</c>.
        /// </value>
        public bool Emergency { get; set; }

        /// <summary>
        /// Gets or sets the type of the booking.
        /// </summary>
        /// <value>
        /// The type of the booking.
        /// </value>
        public string BookingType { get; set; }

        /// <summary>
        /// Gets or sets the lab sample collection detail identifier.
        /// </summary>
        /// <value>
        /// The lab sample collection detail identifier.
        /// </value>
        public int? LabSampleCollectionDetailId { get; set; }

        /// <summary>
        /// Gets or sets the sub sample collected by.
        /// </summary>
        /// <value>
        /// The sub sample collected by.
        /// </value>
        public int? SubSampleCollectedBy { get; set; }

        /// <summary>
        /// Gets or sets the sub barcode generated by.
        /// </summary>
        /// <value>
        /// The sub barcode generated by.
        /// </value>
        public int? SubBarcodeGeneratedBy { get; set; }

        /// <summary>
        /// Gets or sets the sub collection date.
        /// </summary>
        /// <value>
        /// The sub collection date.
        /// </value>
        public DateTime? SubCollectionDate { get; set; }

        /// <summary>
        /// Gets or sets the sub barcode date.
        /// </summary>
        /// <value>
        /// The sub barcode date.
        /// </value>
        public DateTime? SubBarcodeDate { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether [sub is barcode generated].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [sub is barcode generated]; otherwise, <c>false</c>.
        /// </value>
        public bool SubIsBarcodeGenerated { get; set; }

        /// <summary>
        /// Gets or sets the name of the sample.
        /// </summary>
        /// <value>
        /// The name of the sample.
        /// </value>
        public string SampleName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub sample collected by.
        /// </summary>
        /// <value>
        /// The name of the sub sample collected by.
        /// </value>
        public string SubSampleCollectedByName { get; set; }

        /// <summary>
        /// Gets or sets the name of the sub barcode generated by.
        /// </summary>
        /// <value>
        /// The name of the sub barcode generated by.
        /// </value>
        public string SubBarcodeGeneratedByName { get; set; }

        /// <summary>
        /// Gets or sets the sub sample collection location.
        /// </summary>
        /// <value>
        /// The sub sample collection location.
        /// </value>
        public string SubSampleCollectionLocation { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect text.
        /// </summary>
        /// <value>
        /// The no of samples collect text.
        /// </value>
        public string NoOfSamplesCollectText { get; set; }

        /// <summary>
        /// Gets or sets the no of samples collect.
        /// </summary>
        /// <value>
        /// The no of samples collect.
        /// </value>
        public int NoOfSamplesCollect { get; set; }

        /// <summary>
        /// Gets or sets the sub status.
        /// </summary>
        /// <value>
        /// The sub status.
        /// </value>
        public string SubStatus { get; set; }

        /// <summary>
        /// Gets or sets the consent form URL.
        /// </summary>
        /// <value>
        /// The consent form URL.
        /// </value>
        public string ConsentFormUrl { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        /// <value>
        /// The created by.
        /// </value>
        public int? UploadedBy { get; set; }

        /// <summary>
        /// Gets or sets the uploaded date.
        /// </summary>
        /// <value>
        /// The uploaded date.
        /// </value>
        public DateTime? UploadedDate { get; set; }

        /// <summary>
        /// Gets or sets the lab transfer detail identifier.
        /// </summary>
        /// <value>
        /// The lab transfer detail identifier.
        /// </value>
        public int? LabTransferDetailId { get; set; }
    }
}
