﻿namespace Hims.Shared.UserModels.Pharmacy
{
    using System;

    /// <summary>
    /// The pharmacy sale bill.
    /// </summary>
    public class PharmaPurchaseBill
    {

        /// <summary>
        /// Gets or sets the pharmacy product id.
        /// </summary>
        public int PharmacyProductId { get; set; }
        /// <summary>
        /// Gets or sets the BillNumber .
        /// </summary>
        public string BillNumber { get; set; }
        /// <summary>
        /// Gets or sets the BillNumber .
        /// </summary>
        public string BillType { get; set; }
        /// <summary>
        /// Gets or sets the pharmacy product Name.
        /// </summary>
        /// 
        public string ProductName { get; set; }

        /// <summary>
        /// Gets or sets the GenericName Name.
        /// </summary>
        public string GenericName { get; set; }
        /// <summary>
        /// Gets or sets the batch number.
        /// </summary>
        public string BatchNumber { get; set; }

        /// <summary>
        /// Gets or sets the Barcode.
        /// </summary>
        public string Barcode { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the BillDate .
        /// </summary>
        public DateTime BillDate { get; set; }

        /// <summary>
        /// Gets or sets the CategoryName.
        /// </summary>
        public string CategoryName { get; set; }

        /// <summary>
        /// Gets or sets the CompanyName.
        /// </summary>
        public string CompanyName { get; set; }


        /// <summary>
        /// Gets or sets the Supplier id.
        /// </summary>
        public int SupplierId { get; set; }

        /// <summary>
        /// Gets or sets the Supplier Name.
        /// </summary>
        public string SupplierName { get; set; }

        /// <summary>
        /// Gets or sets the quantity.
        /// </summary>
        public int Quantity { get; set; }

        /// <summary>
        /// Gets or sets the free.
        /// </summary>
        public int Free { get; set; }

        /// <summary>
        /// Gets or sets the mrp.
        /// </summary>
        public double Mrp { get; set; }

        /// <summary>
        /// Gets or sets the purchase  rate.
        /// </summary>
        public double PurchaseRate { get; set; }
      /////////////////////////////////////////////////////////////////
        /// <summary>
        /// Gets or sets the total.for purchase product
        /// </summary>
        public double Total { get; set; }

        /// <summary>
        /// Gets or sets the tax amount for per purchase product.
        /// </summary>
        public double TaxAmount { get; set; }


        /// <summary>
        /// Gets or sets the discount amount for per purchase product.
        /// </summary>
        public double DiscountAmount { get; set; }

        /// <summary>
        /// Gets or sets the net amount for per purchase product..
        /// </summary>
        public double NetAmount { get; set; }
        ///////////////////////////////////////////////////////////////
        /// <summary>
        /// Gets or sets the total for purchase Bill.
        /// </summary>
        
        public double BillTotal { get; set; }

        /// <summary>
        /// Gets or sets the tax amount for purchase Bill.
        /// </summary>
        public double BillTaxes { get; set; }


        /// <summary>
        /// Gets or sets the discount amount for purchase Bill.
        /// </summary>
        public double? BillDiscount { get; set; }

        /// <summary>
        /// Gets or sets the net amount for purchase Bill.
        /// </summary>
        public double BillNetAmount { get; set; }
        //////////////////////////////////////////////////ReTurn/////////
        /// <summary>
        /// Gets or sets the ReTurn quantity for per product.
        /// </summary>
        public int ReturnQuantity { get; set; }

        /// <summary>
        /// Gets or sets the Return date for per product.
        /// </summary>
        public DateTime ReturnDate { get; set; }

        /// <summary>
        /// Gets or sets the Return total for per product
        /// </summary>
        public double ReturnTotal { get; set; }
        /// <summary>
        /// Gets or sets the Return NetAmount include (tax& discount)for per product
        /// </summary>
        public double ReturnNetAmount { get; set; }
        /////////////////////////////////////////////////////////////////

        /// <summary>
        /// Gets or sets the Return  OverallBillAmount.
        /// </summary>

        public double OverallBillAmount { get; set; }

        /// <summary>
        /// Gets or sets the  Return OverallTaxes amount.
        /// </summary>
        public double OverallTaxes { get; set; }


        /// <summary>
        /// Gets or sets the Return OverallDiscount amount.
        /// </summary>
        public double OverallDiscount { get; set; }

        /// <summary>
        /// Gets or sets the  Return OverallNetamount.
        /// </summary>
        public double OverallNetamount { get; set; }

        public string LocationName { get; set; }
    }
}
