﻿using Hims.Shared.Dapper.Attributes;
using Hims.Shared.Library.Enums;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Text;

namespace Hims.Shared.UserModels
{
    public class PhysiotherapyEncounterModel
    {
        /// <summary>
        /// Gets or sets the physiotherapyEncounter identifier.
        /// </summary>
        /// <value>
        /// The physiotherapyEncounter identifier.
        /// </value>
        public int? PhysiotherapyEncounterId { get; set; }

        /// <summary>
        /// Gets or sets the appointment id.
        /// </summary>
        public int? AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether active.
        /// </summary>
        public bool? Active { get; set; }

        /// <summary>
        /// Gets or sets the created by.
        /// </summary>
        public int? CreatedBy { get; set; }

        /// <summary>
        /// Gets or sets the created date.
        /// </summary>
        public DateTime? CreatedDate { get; set; }

        /// <summary>
        /// Gets or sets the modified by.
        /// </summary>
        public int? ModifiedBy { get; set; }

        /// <summary>
        /// Gets or sets the modified date.
        /// </summary>
        public DateTime? ModifiedDate { get; set; }

        /// <summary>
        /// Gets or sets the created by name.
        /// </summary>
        public string? CreatedByName { get; set; }

        /// <summary>
        /// Gets or sets the modified by name.
        /// </summary>
        public string? ModifiedByName { get; set; }

        /// <summary>
        /// Gets or sets the encounter type.
        /// </summary>
        public PhysiotherapyEncounterType? Type{ get; set; }

        /// <summary>
        /// Gets or sets the json string.
        /// </summary>
        public string? JsonString { get; set; }

        /// <summary>
        /// Gets or sets the special feature.
        /// </summary>
        public string? SpecialFeature { get; set; }

        /// <summary>
        /// Gets or sets the encrypted appointment id.
        /// </summary>
        public string? EncryptedAppointmentId { get; set; }
        /// <summary>
        /// Gets or sets the login role id.
        /// </summary>
        public int? LoginRoleId { get; set; }
    }
}
